package com.example.iminlibsdemo.utils;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import android.widget.Toast;

import com.device.manager.sdk.DeviceManager;
import com.device.manager.server.aidl.IAsyncCallback;

public class SendCMDUtils {
    public static final String TAG = "SendCMDUtils";
    private static SendCMDUtils instance;
    private DeviceManager iDeviceService;
    private Context mContext;

    public synchronized static SendCMDUtils getInstance() {
        if (instance == null) {
            instance = new SendCMDUtils();
        }
        return instance;
    }

    public void init(Context context) {
        mContext = context;
        iDeviceService = DeviceManager.getDeviceManager(context);
    }

    public void sendCMD(String cmd) {
        if (!iDeviceService.isInitialized()) {
            toast("服务未绑定");
            return;
        }
        try {
            iDeviceService.sendAMCommandAsyn(cmd, new IAsyncCallback.Stub() {
                @Override
                public void onResult(String result) throws RemoteException {
                    Log.d(TAG, result);
                }
            });
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void toast(String s) {
        Toast.makeText(mContext, s, Toast.LENGTH_SHORT).show();
    }
}
