package com.example.iminlibsdemo.utils;


import com.example.iminlibsdemo.bean.DeviceControlBean;

import java.util.ArrayList;
import java.util.List;

public class DeviceControDatalUtils {
    public static final String[] controlData = {"defaultPermissionPolicy", "maximumTimeToLock","encryptionPolicy", "screenCaptureDisabled",
            "cameraDisabled", "keyguardDisabledFeatures", "addUserDisabled", "adjustVolumeDisabled", "factoryResetDisabled",
            "installAppsDisabled", "mountPhysicalMediaDisabled", "modifyAccountsDisabled", "uninstallAppsDisabled", "statusBarDisabled",
            "keyguardDisabled", "bluetoothContactSharingDisabled", "bluetoothConfigDisabled","wifiConfigDisabled","bluetoothDisabled", "cellBroadcastsConfigDisabled",
            "credentialsConfigDisabled", "mobileNetworksConfigDisabled", "vpnConfigDisabled", "createWindowsDisabled", "networkResetDisabled",
            "outgoingBeamDisabled", "outgoingCallsDisabled", "removeUserDisabled","shareLocationDisabled","smsDisabled","setUserIconDisabled",
    "setWallpaperDisabled","dataRoamingDisabled","skipFirstUseHintsEnabled","privateKeySelectionEnabled",
    "stayOnPluggedModes","autoDateAndTimeZone","preferentialNetworkService","printingPolicy"};

    public static List<DeviceControlBean> getDeviceControls() {
        List<DeviceControlBean> result = new ArrayList<>();
        for (int i = 0; i < controlData.length; i++) {
            result.add(getControlBena(controlData[i]));
        }
        return result;
    }

    public static DeviceControlBean getControlBena(String tag) {
        DeviceControlBean result = new DeviceControlBean();
        switch (tag) {
            case "defaultPermissionPolicy":
                result.name = "defaultPermissionPolicy";
                result.type = 0;
                result.infoTips = "用请求的所有权限的默认政策。如果指定，则此配置会替换应用于所有应用的政策";
                result.deviceControls = new ArrayList<>();
                DeviceControlBean.DeviceControl defaultPermissionPolicy1 = new DeviceControlBean.DeviceControl();
                defaultPermissionPolicy1.name = "PROMPT";
                defaultPermissionPolicy1.controlTips = "提示用户授予权限";
                result.deviceControls.add(defaultPermissionPolicy1);
                DeviceControlBean.DeviceControl defaultPermissionPolicy2 = new DeviceControlBean.DeviceControl();
                defaultPermissionPolicy2.name = "GRANT";
                defaultPermissionPolicy2.controlTips = "自动授予权限";
                result.deviceControls.add(defaultPermissionPolicy2);
                DeviceControlBean.DeviceControl defaultPermissionPolicy3 = new DeviceControlBean.DeviceControl();
                defaultPermissionPolicy3.name = "DENY";
                defaultPermissionPolicy3.controlTips = "自动拒绝权限";
                result.deviceControls.add(defaultPermissionPolicy3);
                break;
            case "maximumTimeToLock":
                result.name = "maximumTimeToLock";
                result.type = 0;
                result.infoTips = "用户活动至设备锁定的最长时间（以毫秒为单位）。值为 0 表示没有限制";
                result.deviceControls = new ArrayList<>();
                DeviceControlBean.DeviceControl maximumTimeToLock1 = new DeviceControlBean.DeviceControl();
                maximumTimeToLock1.name = "2000";
                maximumTimeToLock1.controlTips = "设置用户未操作，2000毫秒后息屏";
                result.deviceControls.add(maximumTimeToLock1);
                DeviceControlBean.DeviceControl maximumTimeToLock12 = new DeviceControlBean.DeviceControl();
                maximumTimeToLock12.name = "0";
                maximumTimeToLock12.controlTips = "清除未操作息屏";
                result.deviceControls.add(maximumTimeToLock12);
                break;
            case "stayOnPluggedModes":
                result.name = "stayOnPluggedModes";
                result.type = 0;
                result.infoTips = "电池插入模式，设备保持开启状态";
                result.deviceControls = new ArrayList<>();
                DeviceControlBean.DeviceControl stayOnPluggedModes1 = new DeviceControlBean.DeviceControl();
                stayOnPluggedModes1.name = "BATTERY_PLUGGED_AC";
                stayOnPluggedModes1.controlTips = "电源是交流电源充电器。";
                result.deviceControls.add(stayOnPluggedModes1);
                DeviceControlBean.DeviceControl stayOnPluggedModes2 = new DeviceControlBean.DeviceControl();
                stayOnPluggedModes2.name = "BATTERY_PLUGGED_USB";
                stayOnPluggedModes2.controlTips = " 电源是 USB 端口";
                result.deviceControls.add(stayOnPluggedModes2);
                DeviceControlBean.DeviceControl stayOnPluggedModes3 = new DeviceControlBean.DeviceControl();
                stayOnPluggedModes3.name = "BATTERY_PLUGGED_WIRELESS";
                stayOnPluggedModes3.controlTips = "电源为无线电源";
                result.deviceControls.add(stayOnPluggedModes3);
                break;
            case "autoDateAndTimeZone":
                result.name = "autoDateAndTimeZone";
                result.type = 0;
                result.infoTips = "是否在公司自有设备上启用自动日期、时间和时区功能";
                result.deviceControls = new ArrayList<>();
                DeviceControlBean.DeviceControl autoDateAndTimeZone1 = new DeviceControlBean.DeviceControl();
                autoDateAndTimeZone1.name = "AUTO_DATE_AND_TIME_ZONE_USER_CHOICE";
                autoDateAndTimeZone1.controlTips = "自动日期、时间和时区由用户选择。";
                result.deviceControls.add(autoDateAndTimeZone1);
                DeviceControlBean.DeviceControl autoDateAndTimeZone2 = new DeviceControlBean.DeviceControl();
                autoDateAndTimeZone2.name = "AUTO_DATE_AND_TIME_ZONE_ENFORCED";
                autoDateAndTimeZone2.controlTips = " 在设备上强制启用自动日期、时间和时区设置";
                result.deviceControls.add(autoDateAndTimeZone2);
                break;
            case "preferentialNetworkService":
                result.name = "preferentialNetworkService";
                result.type = 0;
                result.infoTips = "控制是否为工作资料启用优先网络服务。例如，某个组织可能与运营商达成协议，规定来自其员工设备将通过企业专用的网络服务发送";
                result.deviceControls = new ArrayList<>();
                DeviceControlBean.DeviceControl preferentialNetworkService1 = new DeviceControlBean.DeviceControl();
                preferentialNetworkService1.name = "PREFERENTIAL_NETWORK_SERVICE_DISABLED";
                preferentialNetworkService1.controlTips = "工作资料已停用优先网络服务。。";
                result.deviceControls.add(preferentialNetworkService1);
                DeviceControlBean.DeviceControl preferentialNetworkService2 = new DeviceControlBean.DeviceControl();
                preferentialNetworkService2.name = "PREFERENTIAL_NETWORK_SERVICE_ENABLED";
                preferentialNetworkService2.controlTips = "工作资料已启用优先网络服务";
                result.deviceControls.add(preferentialNetworkService2);
                break;
            case "printingPolicy":
                result.name = "printingPolicy";
                result.type = 0;
                result.infoTips = "控制是否为工作资料启用优先网络服务。例如，某个组织可能与运营商达成协议，规定来自其员工设备将通过企业专用的网络服务发送";
                result.deviceControls = new ArrayList<>();
                DeviceControlBean.DeviceControl printingPolicy1 = new DeviceControlBean.DeviceControl();
                printingPolicy1.name = "PRINTING_DISALLOWED";
                printingPolicy1.controlTips = "不允许打印。";
                result.deviceControls.add(printingPolicy1);
                DeviceControlBean.DeviceControl printingPolicy2 = new DeviceControlBean.DeviceControl();
                printingPolicy2.name = "ALLOWED";
                printingPolicy2.controlTips = "PRINTING_ALLOWED";
                result.deviceControls.add(printingPolicy2);
                break;



            case "encryptionPolicy":
                result.name = "encryptionPolicy";
                result.type = 1;
                result.infoTips = "是否已启用加密。";
                result.deviceControls = new ArrayList<>();
                break;

            case "screenCaptureDisabled":
                result.name = "screenCaptureDisabled";
                result.type = 1;
                result.infoTips = "是否停用屏幕截图。";
                result.deviceControls = new ArrayList<>();
                break;
            case "cameraDisabled":
                result.name = "cameraDisabled";
                result.type = 1;
                result.infoTips = "此字段可控制是否停用摄像头：如果为 true，则所有摄像头都处于停用状态，否则可用";
                result.deviceControls = new ArrayList<>();
                break;
            case "addUserDisabled":
                result.name = "addUserDisabled";
                result.type = 1;
                result.infoTips = "是否禁止添加新用户和个人资料";
                result.deviceControls = new ArrayList<>();
                break;
            case "adjustVolumeDisabled":
                result.name = "adjustVolumeDisabled";
                result.type = 1;
                result.infoTips = "是否已停用主音量调节功能。同时将设备静音。";
                result.deviceControls = new ArrayList<>();
                break;
            case "factoryResetDisabled":
                result.name = "factoryResetDisabled";
                result.type = 1;
                result.infoTips = "是否停用了通过设置恢复出厂设置的功能。";
                result.deviceControls = new ArrayList<>();
                break;
            case "installAppsDisabled":
                result.name = "installAppsDisabled";
                result.type = 1;
                result.infoTips = "是否禁止用户安装应用。";
                result.deviceControls = new ArrayList<>();
                break;
            case "mountPhysicalMediaDisabled":
                result.name = "mountPhysicalMediaDisabled";
                result.type = 1;
                result.infoTips = "是否已停用装载实体外部介质的用户。";
                result.deviceControls = new ArrayList<>();
                break;
            case "modifyAccountsDisabled":
                result.name = "modifyAccountsDisabled";
                result.type = 1;
                result.infoTips = "添加或移除账号的功能已停用。";
                result.deviceControls = new ArrayList<>();
                break;
            case "uninstallAppsDisabled":
                result.name = "uninstallAppsDisabled";
                result.type = 1;
                result.infoTips = "是否停用了用户卸载应用。这可以防止应用被卸载，即使是使用  移除的应用也不例外。";
                result.deviceControls = new ArrayList<>();
                break;
            case "statusBarDisabled":
                result.name = "statusBarDisabled";
                result.type = 1;
                result.infoTips = "状态栏是否已停用。这会停用通知、快捷设置和其他允许退出全屏模式的屏幕叠加层。";
                result.deviceControls = new ArrayList<>();
                break;
            case "keyguardDisabled":
                result.name = "keyguardDisabled";
                result.type = 1;
                result.infoTips = "如果为 true，则会停用主显示屏和/或辅助显示屏的锁定屏幕。";
                result.deviceControls = new ArrayList<>();
                break;
            case "bluetoothContactSharingDisabled":
                result.name = "bluetoothContactSharingDisabled";
                result.type = 1;
                result.infoTips = "是否停用蓝牙联系人分享功能。";
                result.deviceControls = new ArrayList<>();
                break;
            case "bluetoothConfigDisabled":
                result.name = "bluetoothConfigDisabled";
                result.type = 1;
                result.infoTips = "是否停用了蓝牙配置。";
                result.deviceControls = new ArrayList<>();
                break;
            case "bluetoothDisabled":
                result.name = "bluetoothDisabled";
                result.type = 1;
                result.infoTips = "是否停用了蓝牙。";
                result.deviceControls = new ArrayList<>();
                break;
            case "wifiConfigDisabled":
                result.name = "wifiConfigDisabled";
                result.type = 1;
                result.infoTips = "是否停用了wifi配置";
                result.deviceControls = new ArrayList<>();
                break;
            case "cellBroadcastsConfigDisabled":
                result.name = "cellBroadcastsConfigDisabled";
                result.type = 1;
                result.infoTips = "是否已停用配置小区广播。";
                result.deviceControls = new ArrayList<>();
                break;
            case "credentialsConfigDisabled":
                result.name = "credentialsConfigDisabled";
                result.type = 1;
                result.infoTips = "是否已停用配置用户凭据的功能。";
                result.deviceControls = new ArrayList<>();
                break;
            case "mobileNetworksConfigDisabled":
                result.name = "mobileNetworksConfigDisabled";
                result.type = 1;
                result.infoTips = "是否已停用配置移动网络。";
                result.deviceControls = new ArrayList<>();
                break;
            case "vpnConfigDisabled":
                result.name = "vpnConfigDisabled";
                result.type = 1;
                result.infoTips = "VPN 配置是否已停用。";
                result.deviceControls = new ArrayList<>();
                break;
            case "createWindowsDisabled":
                result.name = "createWindowsDisabled";
                result.type = 1;
                result.infoTips = "是否禁止创建除应用窗口之外的窗口。";
                result.deviceControls = new ArrayList<>();
                break;
            case "networkResetDisabled":
                result.name = "networkResetDisabled";
                result.type = 1;
                result.infoTips = "是否已停用重置网络设置。";
                result.deviceControls = new ArrayList<>();
                break;
            case "outgoingBeamDisabled":
                result.name = "outgoingBeamDisabled";
                result.type = 1;
                result.infoTips = "是否禁止使用 NFC 从应用传输数据。";
                result.deviceControls = new ArrayList<>();
                break;
            case "outgoingCallsDisabled":
                result.name = "outgoingCallsDisabled";
                result.type = 1;
                result.infoTips = "是否停用拨号。";
                result.deviceControls = new ArrayList<>();
                break;
            case "removeUserDisabled":
                result.name = "removeUserDisabled";
                result.type = 1;
                result.infoTips = "移除其他用户的功能是否停用。";
                result.deviceControls = new ArrayList<>();
                break;
            case "shareLocationDisabled":
                result.name ="shareLocationDisabled";
                result.type = 1;
                result.infoTips ="是否已停用位置信息分享。";
                result.deviceControls = new ArrayList<>();
                break;
            case "smsDisabled":
                result.name ="smsDisabled";
                result.type = 1;
                result.infoTips ="发送和接收短信的功能是否已禁用。";
                result.deviceControls = new ArrayList<>();
                break;
            case "setUserIconDisabled":
                result.name ="setUserIconDisabled";
                result.type = 1;
                result.infoTips ="是否已停用更改用户图标的功能。";
                result.deviceControls = new ArrayList<>();
                break;
            case "setWallpaperDisabled":
                result.name ="setWallpaperDisabled";
                result.type = 1;
                result.infoTips ="是否已停用更换壁纸。";
                result.deviceControls = new ArrayList<>();
                break;
            case "dataRoamingDisabled":
                result.name ="dataRoamingDisabled";
                result.type = 1;
                result.infoTips ="是否停用漫游数据服务。";
                result.deviceControls = new ArrayList<>();
                break;
            case "skipFirstUseHintsEnabled":
                result.name ="skipFirstUseHintsEnabled";
                result.type = 1;
                result.infoTips ="在首次使用时跳过提示的标志。企业管理员可以启用系统建议，让应用在首次启动时跳过用户教程和其他介绍性提示。";
                result.deviceControls = new ArrayList<>();
                break;
            case "privateKeySelectionEnabled":
                result.name ="privateKeySelectionEnabled";
                result.type = 1;
                result.infoTips ="允许在设备上显示界面，以便用户选择私钥别名。对于搭载 Android P 以下版本的设备，设置此政策可能会使企业密钥容易受到攻击。";
                result.deviceControls = new ArrayList<>();
                break;



            case "keyguardDisabledFeatures":
                result.name = "keyguardDisabledFeatures";
                result.type = 0;
                result.infoTips = "已停用键盘锁自定义设置，例如微件。";
                result.deviceControls = new ArrayList<>();
                DeviceControlBean.DeviceControl keyguardDisabledFeatures1 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures1.name = "CAMERA";
                keyguardDisabledFeatures1.controlTips = "在安全的键盘锁屏（例如 PIN 码）上停用相机";
                result.deviceControls.add(keyguardDisabledFeatures1);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures2 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures2.name = "NOTIFICATIONS";
                keyguardDisabledFeatures2.controlTips = "禁止在安全的键盘锁屏幕上显示所有通知";
                result.deviceControls.add(keyguardDisabledFeatures2);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures3 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures3.name = "UNREDACTED_NOTIFICATIONS";
                keyguardDisabledFeatures3.controlTips = "在安全的锁屏界面上停用未隐去信息的通知";
                result.deviceControls.add(keyguardDisabledFeatures3);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures5 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures5.name = "TRUST_AGENTS";
                keyguardDisabledFeatures5.controlTips = "在安全的键盘锁屏幕上忽略可信代理状态";
                result.deviceControls.add(keyguardDisabledFeatures5);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures6 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures6.name = "DISABLE_FINGERPRINT";
                keyguardDisabledFeatures6.controlTips = "停用安全的键盘锁屏幕上的指纹传感器";
                result.deviceControls.add(keyguardDisabledFeatures6);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures7 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures7.name = "DISABLE_REMOTE_INPUT";
                keyguardDisabledFeatures7.controlTips = " 在搭载 Android 6 及更低版本的设备上，禁止在安全的键盘锁屏幕上显示通知文本输入。对 Android 7 及更高版本没有影响";
                result.deviceControls.add(keyguardDisabledFeatures7);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures8 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures8.name = "FACE";
                keyguardDisabledFeatures8.controlTips = "在安全的键盘锁屏幕上停用人脸识别身份验证";
                result.deviceControls.add(keyguardDisabledFeatures8);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures9 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures9.name = "IRIS";
                keyguardDisabledFeatures9.controlTips = "在安全的键盘锁屏幕上停用虹膜识别身份验证";
                result.deviceControls.add(keyguardDisabledFeatures9);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures10 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures10.name = "BIOMETRICS";
                keyguardDisabledFeatures10.controlTips = "在安全的键盘锁屏幕上停用所有生物识别身份验证";
                result.deviceControls.add(keyguardDisabledFeatures10);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures11 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures11.name = "SHORTCUTS";
                keyguardDisabledFeatures11.controlTips = "在 Android 14 及更高版本中，在安全键盘锁屏上停用所有快捷键";
                result.deviceControls.add(keyguardDisabledFeatures11);
                DeviceControlBean.DeviceControl keyguardDisabledFeatures12 = new DeviceControlBean.DeviceControl();
                keyguardDisabledFeatures12.name = "ALL_FEATURES";
                keyguardDisabledFeatures12.controlTips = "停用当前和未来的所有键盘锁自定义";
                result.deviceControls.add(keyguardDisabledFeatures12);
                break;

        }
        return result;
    }
}
