package com.example.iminlibsdemo.ui;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.device.manager.sdk.DeviceManager;
import com.device.manager.server.aidl.IAsyncCallback;
import com.example.iminlibsdemo.R;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.lang.reflect.Method;

public class OEMConfigActivity extends AppCompatActivity implements View.OnClickListener {
    private DeviceManager iDeviceService;
    private static final String TAG = "OEMConfigActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_oem_config);
        iDeviceService = DeviceManager.getDeviceManager(this);
        initListener();

    }

    private void initListener() {
        findViewById(R.id.blue_setting).setOnClickListener(this);
        findViewById(R.id.screentime_setting).setOnClickListener(this);
        findViewById(R.id.alertWindowPermissionSetting).setOnClickListener(this);
        findViewById(R.id.virtualBluetooth_setting).setOnClickListener(this);
        findViewById(R.id.setBlueToothSwitchFalse).setOnClickListener(this);
        findViewById(R.id.setBlueToothSwitchTrue).setOnClickListener(this);
        findViewById(R.id.setWifiSwitchTrue).setOnClickListener(this);
        findViewById(R.id.setWifiSwitchFalse).setOnClickListener(this);


        findViewById(R.id.install).setOnClickListener(this);

    }



    private void installApk() {
        JsonObject controlBean = new JsonObject();
        JsonObject oemConfig = new JsonObject();
        controlBean.add("oemConfig", oemConfig);
        oemConfig.addProperty("installApkPackage","com.example.iminlibsdemo");
        //传入apk路径
        oemConfig.addProperty("installApkPath","/sdcard/usbTest.apk");

        try {
            iDeviceService.sendAMCommandAsyn(new Gson().toJson(controlBean), new IAsyncCallback.Stub() {
                @Override
                public void onResult(String result) {

                    Log.d(TAG, "sendAMCommandAsyn install end: " + result);
                }
            });
        } catch (RemoteException e) {

        }

    }


    @SuppressLint({"DefaultLocale", "NonConstantResourceId"})
    @Override
    public void onClick(View v) {
        if (!iDeviceService.isInitialized()) {
            toast("服务未绑定");
            return;
        }
        try {
            JsonObject controlBean = new JsonObject();
            JsonObject oemConfig = new JsonObject();
            controlBean.add("oemConfig", oemConfig);
            switch (v.getId()) {
                case R.id.blue_setting:
                    EditText editTextBlue = findViewById(R.id.blue_txt);
                    String txtBlue = editTextBlue.getText().toString();
                    oemConfig.addProperty("setBTName", txtBlue);
                    break;
                case R.id.virtualBluetooth_setting:
                    EditText VirtualBluetooth_txt = findViewById(R.id.VirtualBluetooth_txt);
                    String txtVirtualBluetooth = VirtualBluetooth_txt.getText().toString();
                    oemConfig.addProperty("setDeviceVirtualBluetoothName", txtVirtualBluetooth);
                    break;
                case R.id.screentime_setting:
                    EditText edScreenTime = findViewById(R.id.screentime_txt);
                    String txtScreenTime = edScreenTime.getText().toString();
                    oemConfig.addProperty("screenTimeout", txtScreenTime);
                    break;
                case R.id.alertWindowPermissionSetting:
                    EditText AlertWindowPermiss = findViewById(R.id.AlertWindowPermiss_txt);
                    String txtAlertWindowPermiss = AlertWindowPermiss.getText().toString();
                    oemConfig.addProperty("setAppsHaveAlertWindowPermiss", txtAlertWindowPermiss);
                    break;

                //设置wifi开关
                case R.id.setWifiSwitchTrue:
                    oemConfig.addProperty("setWifiSwitch", true);
                    break;

                case R.id.setWifiSwitchFalse:
                    oemConfig.addProperty("setWifiSwitch", false);
                    break;

                //设置蓝牙开关
                case R.id.setBlueToothSwitchTrue:
                    oemConfig.addProperty("setBluetoothSwitch", true);
                    break;

                case R.id.setBlueToothSwitchFalse:
                    oemConfig.addProperty("setBluetoothSwitch", false);
                    break;


                case R.id.install:
                    installApk();
                    break;

            }

            iDeviceService.sendAMCommandAsyn(new Gson().toJson(controlBean), new IAsyncCallback.Stub() {
                @Override
                public void onResult(String result) {
                    toastMain(result);
                    Log.d(TAG, "OEMConfigManager return: " + result);
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, e.getMessage());
        }

    }

    private void toastMain(String result) {
        runOnUiThread(() -> toast(result));
    }

    private void toast(String s) {
        Toast.makeText(this, s, Toast.LENGTH_SHORT).show();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        iDeviceService = null;
    }




}