/*
 * Decompiled with CFR 0.152.
 */
package com.device.manager.sdk.tiramusu.biz;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class IminLightService {
    private String TAG = "IminLightService";
    public static int vId = 25747;
    public static int pId = 42912;
    private static UsbDevice mUsbDevice;
    private UsbInterface mUsbInterface;
    private UsbManager mUsbManager;
    private static IminLightService iminLightService;
    private UsbEndpoint mUsbEndPointIn;
    private UsbEndpoint mUsbEndPointOut;
    private UsbDeviceConnection mUsbDeviceConnection;
    private ThreadPoolExecutor executor;
    private Context context;

    private IminLightService(Context context) {
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IminLightService getInstance(Context context) {
        Class<UsbDevice> clazz = UsbDevice.class;
        synchronized (UsbDevice.class) {
            if (iminLightService == null) {
                iminLightService = new IminLightService(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return iminLightService;
        }
    }

    public UsbDevice getLightDevice() {
        Log.d((String)this.TAG, (String)("Target device pid = " + pId + " vid = " + vId));
        HashMap deviceList = this.mUsbManager.getDeviceList();
        if (deviceList.isEmpty()) {
            Log.d((String)this.TAG, (String)"openUsbDevice Cannot find any usb device");
            return null;
        }
        Iterator deviceIterator = deviceList.values().iterator();
        int iIndex = 0;
        boolean isConnect = false;
        while (deviceIterator.hasNext()) {
            UsbDevice device = (UsbDevice)deviceIterator.next();
            String strValue = "UsbDevice " + ++iIndex + " DeviceClass:" + device.getDeviceClass() + "; DeviceId:" + device.getDeviceId() + "; DeviceName:" + device.getDeviceName() + "; VendorId:" + device.getVendorId() + "; \r\nProductId:" + device.getProductId() + "; InterfaceCount:" + device.getInterfaceCount() + "; describeContents:" + device.describeContents() + ";\r\nDeviceProtocol:" + device.getDeviceProtocol() + ";DeviceSubclass:" + device.getDeviceSubclass() + ";\r\n";
            Log.d((String)this.TAG, (String)("openUsbDevice usb device info : " + strValue));
            if (device.getProductId() != pId || device.getVendorId() != vId) continue;
            Log.d((String)this.TAG, (String)("openUsbDevice matching pid:" + device.getProductId() + " vid:" + device.getVendorId()));
            mUsbDevice = device;
            break;
        }
        return mUsbDevice;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean connectUsbDevice() {
        this.mUsbInterface = mUsbDevice.getInterface(0);
        int endpointCount = this.mUsbInterface.getEndpointCount();
        for (int i = 0; i < endpointCount; ++i) {
            UsbEndpoint usbEndpoint = this.mUsbInterface.getEndpoint(i);
            Log.d((String)this.TAG, (String)("usbEndpoint.getDirection()=" + usbEndpoint.getDirection() + ", usbEndpoint.getDirection()=" + usbEndpoint.getDirection()));
            if (usbEndpoint.getDirection() == 128) {
                this.mUsbEndPointIn = usbEndpoint;
                continue;
            }
            if (usbEndpoint.getDirection() != 0) continue;
            this.mUsbEndPointOut = usbEndpoint;
        }
        if (this.mUsbEndPointIn != null && this.mUsbEndPointOut != null) {
            Log.d((String)this.TAG, (String)"connectUsbDevice mUsbEndPointIn != null");
            if (!this.mUsbManager.hasPermission(mUsbDevice)) {
                mUsbDevice = null;
                Log.d((String)this.TAG, (String)"connectUsbDevice Permission denied");
                return false;
            }
            this.mUsbDeviceConnection = this.mUsbManager.openDevice(mUsbDevice);
            if (this.mUsbDeviceConnection == null) {
                Log.d((String)this.TAG, (String)"connectUsbDevice unable to connect to device");
                return false;
            }
            if (!this.mUsbDeviceConnection.claimInterface(this.mUsbInterface, true)) {
                Log.d((String)this.TAG, (String)"connectUsbDevice unable to claim interface");
                return false;
            }
            Log.d((String)this.TAG, (String)"connectUsbDevice init success");
            return true;
        }
        Log.d((String)this.TAG, (String)"connectUsbDevice Missing usb endpoints");
        return false;
    }

    public void closeUsbDevice() {
        Log.d((String)this.TAG, (String)"closeUsbDevice");
        if (mUsbDevice == null) {
            return;
        }
        try {
            if (this.mUsbDeviceConnection != null && this.mUsbInterface != null) {
                this.mUsbDeviceConnection.releaseInterface(this.mUsbInterface);
                this.mUsbInterface = null;
                this.mUsbDeviceConnection.close();
                this.mUsbDeviceConnection = null;
                mUsbDevice = null;
                this.mUsbEndPointOut = null;
                this.mUsbEndPointIn = null;
            }
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)("closeUsbDevice exception: " + e.getMessage()));
        }
    }

    public void turnOnGreenLight() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                IminLightService.this.setLedState(IminLightService.this.context, 0, 0);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IminLightService.this.setLedState(IminLightService.this.context, 1, 1);
            }
        });
    }

    public void turnOnRedLight() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                IminLightService.this.setLedState(IminLightService.this.context, 1, 0);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IminLightService.this.setLedState(IminLightService.this.context, 0, 1);
            }
        });
    }

    public void turnOffLight() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                IminLightService.this.setLedState(IminLightService.this.context, 1, 0);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IminLightService.this.setLedState(IminLightService.this.context, 0, 0);
            }
        });
    }

    public void setLedState(Context context, int id, int state) {
        byte[] sendCmd = new byte[15];
        int index = 0;
        sendCmd[index++] = -86;
        sendCmd[index++] = -86;
        sendCmd[index++] = -125;
        sendCmd[index++] = 2;
        sendCmd[index++] = (byte)id;
        sendCmd[index++] = (byte)state;
        sendCmd[index++] = 0;
        sendCmd[index++] = 0;
        sendCmd[index++] = 0;
        sendCmd[index++] = 0;
        sendCmd[index++] = 0;
        sendCmd[index++] = 0;
        sendCmd[index++] = 0;
        sendCmd[index++] = 0;
        sendCmd[index] = IminLightService.getCmdSum(sendCmd);
        if (this.mUsbDeviceConnection != null && this.mUsbEndPointOut != null) {
            int i = this.mUsbDeviceConnection.bulkTransfer(this.mUsbEndPointOut, sendCmd, sendCmd.length, 0);
            if (i > 0) {
                Log.d((String)this.TAG, (String)("setLedState \u6210\u529f i = " + i + "  sendCmd:" + Arrays.toString(sendCmd)));
            } else {
                Log.d((String)this.TAG, (String)("setLedState \u5931\u8d25 i = " + i + "  sendCmd:" + Arrays.toString(sendCmd)));
            }
        } else {
            Log.d((String)this.TAG, (String)("mUsbDeviceConnection=" + this.mUsbDeviceConnection + ", mUsbEndPointOut=" + this.mUsbEndPointOut));
        }
    }

    private static byte getCmdSum(byte[] sendCmd) {
        int sum = 0;
        for (byte b : sendCmd) {
            sum += b;
        }
        return (byte)sum;
    }

    private int parseAssisData(byte[] mBytes) {
        int iValue = 0;
        if (mBytes.length == 8 && mBytes[0] == 2) {
            byte bValue = mBytes[1];
            iValue = IminLightService.byte2Int(bValue);
            Log.d((String)this.TAG, (String)("parseAssisData bValue = " + bValue + "  iValue = " + iValue));
        }
        return iValue;
    }

    public static int byte2Int(byte b) {
        return b < 0 ? b & 0xFF : b;
    }
}

