/*
 * Decompiled with CFR 0.152.
 */
package com.device.manager.sdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.hardware.usb.UsbDevice;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.device.manager.sdk.bean.ApplicationDetail;
import com.device.manager.sdk.bean.BarcodeScannerDetail;
import com.device.manager.sdk.bean.BatteryDetail;
import com.device.manager.sdk.bean.BuiltinCellularDetail;
import com.device.manager.sdk.bean.CPUDetail;
import com.device.manager.sdk.bean.CameraDetail;
import com.device.manager.sdk.bean.DeviceDetail;
import com.device.manager.sdk.bean.EmmcEmbeddedMultimediaCardDetail;
import com.device.manager.sdk.bean.MemoryDetail;
import com.device.manager.sdk.bean.NFCDetail;
import com.device.manager.sdk.bean.PrinterDetail;
import com.device.manager.sdk.bean.StorageDetail;
import com.device.manager.sdk.bean.VideoDisplayDetail;
import com.device.manager.sdk.bean.WIFIDetail;
import com.device.manager.sdk.tiramusu.A13DeviceService;
import com.device.manager.sdk.tiramusu.biz.IminLightService;
import com.device.manager.sdk.tiramusu.biz.IminPsamService;
import com.device.manager.server.aidl.IAsyncCallback;
import com.device.manager.server.aidl.IDeviceService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public class DeviceManager {
    private static final String TAG = "DeviceManager";
    private static final String BIND_SERVICE_ACTION = "android.intent.action.RESPOND_AIDL_MESSAGE";
    private IDeviceService iDeviceService;
    private static DeviceManager deviceManager = null;
    public static final String DEVICE_INFO_ALL = "DEVICE_INFO_ALL";
    private Gson mGson = new Gson();
    public static final String DEVICE_INFO_HW_INFO = "DEVICE_INFO_HW_INFO";
    public static final String DEVICE_INFO_NETWORK_INFO = "DEVICE_INFO_NETWORK_INFO";
    public static final String DEVICE_INFO_SW_INFO = "DEVICE_INFO_SW_INFO";
    public static final String DEVICE_INFO_DISPLAY_INFO = "DEVICE_INFO_DISPLAY_INFO";
    public static final String DEVICE_INFO_MEMORY_INFO = "DEVICE_INFO_MEMORY_INFO";
    public static final String DEVICE_INFO_APPLICATION_REPORT = "DEVICE_INFO_APPLICATION_REPORT";
    public static final String DEVICE_INFO_DEVICE_SETTINGS = "DEVICE_INFO_DEVICE_SETTINGS";
    public static final String DEVICE_INFO_PASSWORD_REQUIREMENTS = "DEVICE_INFO_PASSWORD_REQUIREMENTS";
    public static final String DEVICE_INFO_SECURITY_POSTURE = "DEVICE_INFO_SECURITY_POSTURE";
    private final ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            DeviceManager.this.iDeviceService = IDeviceService.Stub.asInterface(service);
            Log.d((String)DeviceManager.TAG, (String)("onServiceConnected: " + DeviceManager.this.iDeviceService));
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.d((String)DeviceManager.TAG, (String)"onServiceDisconnected: ");
            DeviceManager.this.iDeviceService = null;
        }
    };

    private DeviceManager(Context context) {
        this(context, true);
    }

    private DeviceManager(Context context, boolean needDeviceOwner) {
        if (Build.VERSION.SDK_INT <= 33) {
            this.iDeviceService = new A13DeviceService(context);
        } else {
            Intent mServiceIntent = new Intent();
            mServiceIntent.setAction(BIND_SERVICE_ACTION);
            mServiceIntent.putExtra("needDeviceOwner", needDeviceOwner);
            mServiceIntent.setComponent(new ComponentName("com.device.manager.server", "com.device.manager.server.DeviceManagerService"));
            context.bindService(mServiceIntent, this.serviceConnection, 1);
        }
    }

    public static DeviceManager getDeviceManager(Context context) {
        if (deviceManager == null) {
            deviceManager = new DeviceManager(context);
        }
        return deviceManager;
    }

    public static DeviceManager getDeviceManager(Context context, boolean needDeviceOwner) {
        if (deviceManager == null) {
            deviceManager = new DeviceManager(context, needDeviceOwner);
        }
        return deviceManager;
    }

    public static void initialize(Context context) {
        if (deviceManager == null) {
            deviceManager = new DeviceManager(context);
        }
    }

    public boolean isInitialized() {
        return deviceManager != null && this.iDeviceService != null;
    }

    public String getProp(String name) throws RemoteException {
        Log.d((String)TAG, (String)"getProp");
        if (this.iDeviceService != null) {
            return this.iDeviceService.getSystemProperties(name);
        }
        return "";
    }

    public void getDeviceInfoAsyn(String name, IAsyncCallback callback) throws RemoteException {
        Log.d((String)TAG, (String)"getDeviceInfoAsyn");
        if (this.iDeviceService != null) {
            this.iDeviceService.getDeviceInfoAsyn(name, callback);
        }
    }

    public void sendAMCommandAsyn(String cmd, IAsyncCallback callback) throws RemoteException {
        Log.d((String)TAG, (String)"sendAMCommandAsyn");
        if (this.iDeviceService != null) {
            this.iDeviceService.sendAMCommandAsyn(cmd, callback);
        }
    }

    public void sendDeviceActionAsyn(String cmd, String pamars, IAsyncCallback callback) throws RemoteException {
        Log.d((String)TAG, (String)"sendDeviceActionAsyn");
        if (this.iDeviceService != null) {
            this.iDeviceService.sendDeviceActionAsyn(cmd, pamars, callback);
        }
    }

    public List<BarcodeScannerDetail> getBarcodeScannerDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getBarcodeScannerDetails");
        List barcodeScannerDetailList = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getBarcodeScannerDetails();
            Type personListType = new TypeToken<List<BarcodeScannerDetail>>(){}.getType();
            barcodeScannerDetailList = (List)this.mGson.fromJson(result, personListType);
        }
        return barcodeScannerDetailList;
    }

    public List<VideoDisplayDetail> getVideoDisplayDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getVideoDisplayDetails");
        List videoDisplayDetails = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getVideoDisplayDetails();
            Type personListType = new TypeToken<List<VideoDisplayDetail>>(){}.getType();
            videoDisplayDetails = (List)this.mGson.fromJson(result, personListType);
        }
        return videoDisplayDetails;
    }

    public EmmcEmbeddedMultimediaCardDetail getEmmcEmbeddedMultimediaCardDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getEmmcEmbeddedMultimediaCardDetails");
        EmmcEmbeddedMultimediaCardDetail embeddedMultimediaCardDetail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getEmmcEmbeddedMultimediaCardDetails();
            embeddedMultimediaCardDetail = (EmmcEmbeddedMultimediaCardDetail)this.mGson.fromJson(result, EmmcEmbeddedMultimediaCardDetail.class);
        }
        return embeddedMultimediaCardDetail;
    }

    public NFCDetail getNFCDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getEmmcEmbeddedMultimediaCardDetails");
        NFCDetail detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getNFCDetails();
            detail = (NFCDetail)this.mGson.fromJson(result, NFCDetail.class);
        }
        return detail;
    }

    public BuiltinCellularDetail getBuiltinCellularDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getEmmcEmbeddedMultimediaCardDetails");
        BuiltinCellularDetail detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getBuiltinCellularDetails();
            detail = (BuiltinCellularDetail)this.mGson.fromJson(result, BuiltinCellularDetail.class);
        }
        return detail;
    }

    public List<CameraDetail> getCameraDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getEmmcEmbeddedMultimediaCardDetails");
        List detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getCameraDetails();
            Type userListType = new TypeToken<List<CameraDetail>>(){}.getType();
            detail = (List)new Gson().fromJson(result, userListType);
        }
        return detail;
    }

    public DeviceDetail getDeviceDetail() throws RemoteException {
        Log.d((String)TAG, (String)"getEmmcEmbeddedMultimediaCardDetails");
        DeviceDetail detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getDeviceDetail();
            detail = (DeviceDetail)this.mGson.fromJson(result, DeviceDetail.class);
        }
        return detail;
    }

    public MemoryDetail getMemoryDetail() throws RemoteException {
        Log.d((String)TAG, (String)"getEmmcEmbeddedMultimediaCardDetails");
        MemoryDetail detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getMemoryDetail();
            detail = (MemoryDetail)this.mGson.fromJson(result, MemoryDetail.class);
        }
        return detail;
    }

    public BatteryDetail getBatteryDetail() throws RemoteException {
        Log.d((String)TAG, (String)"getEmmcEmbeddedMultimediaCardDetails");
        BatteryDetail detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getBatteryDetail();
            detail = (BatteryDetail)this.mGson.fromJson(result, BatteryDetail.class);
        }
        return detail;
    }

    public CPUDetail getCPUDetail() throws RemoteException {
        Log.d((String)TAG, (String)"getEmmcEmbeddedMultimediaCardDetails");
        CPUDetail detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getCPUDetail();
            detail = (CPUDetail)this.mGson.fromJson(result, CPUDetail.class);
        }
        return detail;
    }

    public WIFIDetail getWIFIDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getWIFIDetails");
        WIFIDetail detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getWIFIDetails();
            detail = (WIFIDetail)this.mGson.fromJson(result, WIFIDetail.class);
        }
        return detail;
    }

    public List<PrinterDetail> getPrinterDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getWIFIDetails");
        List detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getPrinterDetails();
            Type userListType = new TypeToken<List<PrinterDetail>>(){}.getType();
            detail = (List)new Gson().fromJson(result, userListType);
        }
        return detail;
    }

    public StorageDetail getStorageDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getWIFIDetails");
        StorageDetail detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getStorageDetails();
            detail = (StorageDetail)this.mGson.fromJson(result, StorageDetail.class);
        }
        return detail;
    }

    public List<ApplicationDetail> getApplicationDetails() throws RemoteException {
        Log.d((String)TAG, (String)"getWIFIDetails");
        List detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getApplicationDetails();
            Type userListType = new TypeToken<List<ApplicationDetail>>(){}.getType();
            detail = (List)new Gson().fromJson(result, userListType);
        }
        return detail;
    }

    public void getARPList(IAsyncCallback callback) throws RemoteException {
        Log.d((String)TAG, (String)"getARPList");
        List detail = null;
        if (this.iDeviceService != null) {
            String result = this.iDeviceService.getApplicationDetails();
            Type userListType = new TypeToken<List<ApplicationDetail>>(){}.getType();
            detail = (List)new Gson().fromJson(result, userListType);
        }
    }

    public int openPsam(Context context, byte slot, byte vccMode, byte[] ATR) {
        return IminPsamService.getInstance().openPsam(context, slot, vccMode, ATR);
    }

    public int closePsam(Context context, byte slot) {
        return IminPsamService.getInstance().closePsam(context, slot);
    }

    public int commandPsam(Context context, byte slot, byte[] apduSend, byte[] apduRecv) {
        return IminPsamService.getInstance().commandPsam(context, slot, apduSend, apduRecv);
    }

    public int commandPsamNew(Context context, byte slot, byte[] apduSend, byte[] apduRecv) {
        return IminPsamService.getInstance().commandPsamNew(context, slot, apduSend, apduRecv);
    }

    public int iccDevParaSet(Context context, byte slot, byte clkSel, byte mode, byte pps) {
        return IminPsamService.getInstance().iccDevParaSet(context, slot, clkSel, mode, pps);
    }

    public UsbDevice getLightDevice(Context context) {
        return IminLightService.getInstance(context).getLightDevice();
    }

    public boolean connectLightDevice(Context context) {
        return IminLightService.getInstance(context).connectUsbDevice();
    }

    public void turnOnGreenLight(Context context) {
        IminLightService.getInstance(context).turnOnGreenLight();
    }

    public void turnOnRedLight(Context context) {
        IminLightService.getInstance(context).turnOnRedLight();
    }

    public void turnOffLight(Context context) {
        IminLightService.getInstance(context).turnOffLight();
    }

    public void disconnectLightDevice(Context context) {
        IminLightService.getInstance(context).closeUsbDevice();
    }

    public void setHideStatusBar(Context context, boolean hide) {
        try {
            Object iMinServiceManager = context.getSystemService("iminservice");
            Class<?> c = Class.forName("android.app.iMinServiceManager");
            Method method = c.getMethod("setHideStatusBarforiMin", Boolean.TYPE);
            method.invoke(iMinServiceManager, hide);
            Log.d((String)TAG, (String)" setHideStatusBarforiMin ");
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Log.d((String)TAG, (String)" setHideStatusBarforiMin sendBroadcast");
            e.printStackTrace();
            String HIDE_STATUS_BAR = "android.intent.action.HIDE_STATUS_BAR";
            Intent intent2 = new Intent(HIDE_STATUS_BAR);
            intent2.putExtra("isHide_statusbar", hide + "");
            intent2.setPackage("com.android.systemui");
            context.sendBroadcast(intent2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setHideNavigationBar(Context context, boolean hide) {
        try {
            Log.d((String)TAG, (String)" setHideNavigationBarforiMin ");
            Object iMinServiceManager = context.getSystemService("iminservice");
            Class<?> c = Class.forName("android.app.iMinServiceManager");
            Method method = c.getMethod("setHideNavigationBarforiMin", Boolean.TYPE);
            method.invoke(iMinServiceManager, hide);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)" setHideNavigationBarforiMin sendBroadcast ");
            Intent intent = new Intent("android.intent.action.HIDE_NAV_BAR");
            intent.putExtra("isHide_nav", hide + "");
            intent.setPackage("com.android.systemui");
            context.sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

