/*
 * Decompiled with CFR 0.152.
 */
package com.device.manager.sdk.tiramusu.biz;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.device.manager.sdk.tiramusu.biz.IminDeviceUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SystemPropBean {
    private static String TAG = "SystemPropUtils";
    private String model = null;
    private double mInch = 0.0;
    private boolean isUseImimPrintLibs = false;
    private static volatile SystemPropBean mInstance = null;
    private ArrayList<String> notSuuperTouch = new ArrayList();
    private boolean isSupperSecondTouch = false;

    private SystemPropBean() {
        this.model = this.getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemPropBean getInstance() {
        if (mInstance != null) return mInstance;
        Class<SystemPropBean> clazz = SystemPropBean.class;
        synchronized (SystemPropBean.class) {
            if (mInstance != null) return mInstance;
            mInstance = new SystemPropBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public String getSn() {
        if (Build.VERSION.SDK_INT >= 29) {
            if ("".equals(this.getSystemProperties("ro.serialno"))) {
                return this.getSystemProperties("persist.sys.imin.sn");
            }
            return this.getSystemProperties("ro.serialno");
        }
        return Build.SERIAL;
    }

    public String getModel() {
        if (this.model != null) {
            return this.model;
        }
        if (Build.VERSION.SDK_INT >= 33) {
            String model = this.getSystemProperties("persist.sys.model");
            if (TextUtils.isEmpty((CharSequence)model)) {
                model = Build.MODEL;
            }
            return model;
        }
        this.model = "";
        this.isSupperSecondTouch = false;
        String plaform = this.getPlaform();
        if (!TextUtils.isEmpty((CharSequence)plaform) && plaform.startsWith("mt")) {
            this.model = this.getSystemProperties("ro.neostra.imin_model");
        } else if (!TextUtils.isEmpty((CharSequence)plaform) && plaform.startsWith("ums512")) {
            this.model = Build.MODEL;
        } else if (!TextUtils.isEmpty((CharSequence)plaform) && plaform.startsWith("sp9863a")) {
            this.model = Build.MODEL;
            if (this.model.equals("I22M01")) {
                this.model = "MS1-11";
            }
        } else {
            this.model = this.getSystemProperties("sys.neostra_oem_id");
            Log.d((String)TAG, (String)("model " + this.model));
            if (!TextUtils.isEmpty((CharSequence)this.model) && this.model.length() > 4) {
                String num28;
                this.model = this.filterModel(this.model.substring(0, 5));
                String oemId = this.getSystemProperties("sys.neostra_oem_id");
                if (oemId.length() > 27 && oemId.startsWith("W26MP") && "S".equalsIgnoreCase(num28 = String.valueOf(oemId.charAt(27)))) {
                    this.model = "D3-510";
                }
            } else {
                this.model = this.getSystemProperties("ro.neostra.imin_model");
            }
            if ("".equals(this.model)) {
                this.model = Build.MODEL;
                if (this.model.equals("I22D01")) {
                    this.model = "DS1-11";
                }
            }
        }
        return this.model;
    }

    public String getBrand() {
        String brand = Build.BRAND;
        if (Build.VERSION.SDK_INT >= 33) {
            brand = this.getSystemProperties("persist.sys.romtype");
            String roBrand = Build.BRAND;
            if (!TextUtils.isEmpty((CharSequence)roBrand) && !roBrand.equalsIgnoreCase("imin")) {
                brand = roBrand;
            }
        }
        if (brand.equalsIgnoreCase("yimin")) {
            return "YiMin";
        }
        if (!TextUtils.isEmpty((CharSequence)this.model) && this.isIminDevie()) {
            return "iMin";
        }
        return brand;
    }

    private boolean isIminDevie() {
        return !TextUtils.isEmpty((CharSequence)this.model) && (this.model.contains("D3-504") || this.model.contains("D3-505") || this.model.contains("D3-506") || this.model.contains("D1-Pro") || this.model.equals("D1") || this.model.contains("D1-503") || this.model.contains("D1-501") || this.model.contains("D1p-602") || this.model.contains("D1p-603") || this.model.contains("D2-401") || this.model.contains("D2-402") || this.model.contains("D2 Pro") || this.model.contains("D1w-703") || this.model.contains("D1w-702") || this.model.contains("D1w-701") || this.model.contains("D4-501") || this.model.contains("D4-502") || this.model.contains("D4-503") || this.model.contains("D4-504") || this.model.contains("D4-505") || this.model.contains("K2-201") || this.model.contains("K1-101") || this.model.contains("R1-202") || this.model.contains("R1-201") || this.model.contains("S1-701") || this.model.contains("S1-702") || this.model.contains("M2-Max") || this.model.contains("M2-Pro") || this.model.contains("M2-203") || this.model.contains("M2-202") || this.model.contains("TF1-11") || this.model.contains("IF22-1") || this.model.contains("Swift 1") || this.model.contains("Swan 1") || this.model.contains("Lark 1") || this.model.contains("DS1-11") || this.model.contains("Falcon 1"));
    }

    public String getCup() {
        String id;
        if ("D4-505".equals(this.model) && !TextUtils.isEmpty((CharSequence)(id = this.getSystemProperties("sys.neostra_oem_id"))) && id.startsWith("W27DP")) {
            return "Rockchip 6 Core\nDual-core Cortex-A72\nQuad-core Cortex-A53";
        }
        switch (this.model) {
            case "D3-504": 
            case "D3-505": 
            case "D3-506": 
            case "K2-201": 
            case "D4-501": 
            case "D4-502": 
            case "D4-503": 
            case "D4-504": 
            case "D4-505": 
            case "K1-101": 
            case "S1-701": 
            case "S1-702": {
                if ("W17PX".equals(this.getModel())) {
                    return "Quad-Core ARM Cortex-A55";
                }
                return "Quad-core ARM Cortex-A17";
            }
            case "R2-301": {
                return "Rockchip 6 core \nDual-Core Cortex-A72 UP to 1.8GHz\nQual-Core Cortex-A53 UP to 1.4GHz";
            }
            case "D2-402": 
            case "D2-401": 
            case "D2 Pro": {
                String id2 = this.getSystemProperties("sys.neostra_oem_id");
                if (!TextUtils.isEmpty((CharSequence)id2) && (id2.startsWith("V1GPX") || id2.startsWith("V1PXX"))) {
                    return "Quad-core Cortex-A55";
                }
                return "Quad-core ARM Cortex-A53";
            }
            case "M2-Max": 
            case "M2-Pro": 
            case "D1": 
            case "D1-Pro": {
                return "8-core \nDual*A75 UP to 1.8GHz\nHexa*A55 UP to 1.8GHz";
            }
            case "MS1-11": 
            case "Swift 1": {
                return "8-core ARM Cortex-A55";
            }
            case "DS1-11": 
            case "Swan 1": {
                return "Quad-core ARM Cortex-A55";
            }
            case "FI22-1": 
            case "IF22-1": 
            case "Lark 1": {
                return "8-Core Arm Cortex-A55";
            }
            case "M2-202": {
                return "4-Core, Quad*Cortex-A35, 1.3GHz";
            }
            case "M2-203": {
                return "Quad-core ARM Cortex-A53 1.28GHz";
            }
        }
        return "";
    }

    public String getCpuMaxFreq() {
        String id;
        if ("D4-505".equals(this.model) && !TextUtils.isEmpty((CharSequence)(id = this.getSystemProperties("sys.neostra_oem_id"))) && id.startsWith("W27DP")) {
            return "1.8GHz";
        }
        switch (this.model) {
            case "R2-301": {
                return "0";
            }
            case "D2-402": 
            case "D2-401": 
            case "D2 Pro": {
                String id2 = this.getSystemProperties("sys.neostra_oem_id");
                if (!TextUtils.isEmpty((CharSequence)id2) && (id2.startsWith("V1GPX") || id2.startsWith("V1PXX"))) {
                    return "1.8GHz";
                }
                return "1.5GHz";
            }
            case "MS1-11": 
            case "Swift 1": 
            case "FI22-1": 
            case "IF22-1": 
            case "Lark 1": {
                return "1.6GHz";
            }
            case "DS1-11": 
            case "Swan 1": {
                return "2.0GHz";
            }
            case "S1-701": {
                return "2.0GHZ";
            }
        }
        return "";
    }

    public String getDualscreenProp() {
        return this.getSystemProperties("sys.dualscreen");
    }

    public boolean isSupperSecondTouch() {
        return this.isSupperSecondTouch;
    }

    public boolean isSupperSweep() {
        switch (this.model) {
            case "R2-301": 
            case "FI22-1": 
            case "IF22-1": 
            case "Lark 1": {
                return false;
            }
        }
        return true;
    }

    public boolean isSupperCashBox() {
        String pModel = this.model;
        if (Build.VERSION.SDK_INT >= 33) {
            pModel = this.getSystemProperties("persist.sys.neo_model");
            return IminDeviceUtils.isSupportCashBox(pModel);
        }
        switch (pModel) {
            case "R2-301": 
            case "M2-Max": 
            case "M2-Pro": 
            case "MS1-11": 
            case "Swift 1": 
            case "FI22-1": 
            case "IF22-1": 
            case "Lark 1": 
            case "S1-701": {
                return false;
            }
        }
        return true;
    }

    public long fakeStorageSize(long privateTotalBytes) {
        long flashSize = privateTotalBytes / 1024L / 1024L / 1024L;
        if (flashSize <= 0L) {
            flashSize = 0L;
        } else if (flashSize <= 1L) {
            flashSize = 1L;
        } else if (flashSize <= 2L) {
            flashSize = 2L;
        } else if (flashSize <= 4L) {
            flashSize = 4L;
        } else if (flashSize <= 8L) {
            flashSize = 8L;
        } else if (flashSize <= 16L) {
            flashSize = 16L;
        } else if (flashSize <= 32L) {
            flashSize = 32L;
        } else if (flashSize <= 64L) {
            flashSize = 64L;
        } else if (flashSize <= 128L) {
            flashSize = 128L;
        } else if (flashSize <= 256L) {
            flashSize = 256L;
        }
        privateTotalBytes = flashSize * 1024L * 1024L * 1024L;
        return privateTotalBytes;
    }

    public String getPlaform() {
        if (Build.VERSION.SDK_INT >= 33) {
            return Build.HARDWARE;
        }
        return this.getSystemProperties("ro.board.platform");
    }

    public String getSystemProperties(String property) {
        String value = "";
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method getter = clazz.getDeclaredMethod("get", String.class);
            value = (String)getter.invoke(null, property);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Unable to read system properties");
        }
        return value;
    }

    public double getScreenSize() {
        return this.mInch;
    }

    public boolean isUseImimPrintLibs() {
        return this.isUseImimPrintLibs;
    }

    private String filterModel(String str) {
        switch (str) {
            case "W21XX": {
                return "D1-501";
            }
            case "W21MX": {
                return "D1-502";
            }
            case "W21DX": {
                return "D1-503";
            }
            case "W22XX": {
                return "D1p-601";
            }
            case "W22MX": {
                return "D1p-602";
            }
            case "W22DX": {
                return "D1p-603";
            }
            case "W22DC": {
                return "D1p-604";
            }
            case "W23XX": {
                return "D1w-701";
            }
            case "W23MX": {
                return "D1w-702";
            }
            case "W23DX": {
                return "D1w-703";
            }
            case "W23DC": {
                return "D1w-704";
            }
            case "V1GXX": 
            case "V1GPX": {
                return "D2-401";
            }
            case "V1XXX": 
            case "V1PXX": {
                return "D2-402";
            }
            case "V2BXX": {
                return "D2 Pro";
            }
            case "1824P": {
                if (this.getSystemProperties("persist.sys.customername").equals("ZKSY")) {
                    return "ZKSY-301";
                }
                if (this.getSystemProperties("persist.sys.customername").equals("K3")) {
                    return "K3";
                }
                return "D3-501";
            }
            case "P24MP": {
                String customerName = this.getSystemProperties("persist.sys.customername");
                if (customerName.equals("2Dfire")) {
                    return "P10M";
                }
                if (customerName.equals("ZKSY")) {
                    return "ZKSY-302";
                }
                if (customerName.equalsIgnoreCase("Bestway")) {
                    return "V5-1824M Plus";
                }
                if (customerName.equalsIgnoreCase("idiotehs")) {
                    return "CTA-D3M";
                }
                return "D3-503";
            }
            case "P24XP": {
                return "D3-502";
            }
            case "W26XX": 
            case "W26PX": {
                return "D3-504";
            }
            case "W26MX": 
            case "W26MP": {
                return "D3-505";
            }
            case "W27LX": {
                return "D4-501";
            }
            case "W27LD": {
                return "D4-502";
            }
            case "W27XX": 
            case "W27PX": {
                return "D4-503";
            }
            case "W27MX": 
            case "W27MP": {
                return "D4-504";
            }
            case "W27DX": {
                return "D4-505";
            }
            case "1824M": {
                return "1824M";
            }
            case "1824D": {
                return "1824D";
            }
            case "K21XX": {
                return "K1-101";
            }
            case "D20XX": {
                return "R1-201";
            }
            case "D20TX": {
                return "R1-202";
            }
            case "W17BX": {
                this.mInch = 21.5;
                this.isUseImimPrintLibs = true;
                return "S1-702";
            }
            case "W17XX": 
            case "W17PX": {
                this.mInch = 21.5;
                this.isUseImimPrintLibs = true;
                return "S1-701";
            }
            case "W26HX": {
                return "D3-504";
            }
            case "W26HM": {
                return "D3-505";
            }
            case "W26HD": {
                return "D3-506";
            }
            case "W26HG": 
            case "W26GP": {
                return "K2-201";
            }
            case "D224G": {
                return "R2-301";
            }
            case "D22XX": {
                return "R2-301";
            }
            case "D22TX": {
                return "R2-302";
            }
            case "W27DP": {
                return "D4-505";
            }
            case "K21PX": {
                return "K1-101";
            }
            case "W23PX": {
                return "D1w-701";
            }
            case "W23MP": {
                return "D1w-702";
            }
            case "W23DP": {
                return "D1w-703";
            }
            case "W28XX": {
                return "Swan 1";
            }
            case "W28MX": {
                String customerName = this.getSystemProperties("persist.sys.customername");
                if (customerName.equals("2Dfire")) {
                    return "P5";
                }
                if ("Dingjian".equals(customerName)) {
                    return "DJ-P28";
                }
                if ("baohuoli".equalsIgnoreCase(customerName)) {
                    return "FS-5216";
                }
                return "Swan 1";
            }
            case "W28GX": {
                String w28gxCustomerName = this.getSystemProperties("persist.sys.customername");
                if (w28gxCustomerName.equals("2Dfire")) {
                    return "P5K";
                }
                if ("Dingjian".equals(w28gxCustomerName)) {
                    return "DJ-P28K";
                }
                if ("baohuoli".equalsIgnoreCase(w28gxCustomerName)) {
                    return "FS-5216";
                }
                return "Swan 1k";
            }
            case "W26DP": {
                return "D3-506";
            }
            case "26PXX": {
                return "P10CS";
            }
            case "26MPX": {
                return "P10DS";
            }
        }
        return "";
    }

    public static void setProperties(String key, String defvalue) {
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method set = c.getMethod("set", String.class, String.class);
            set.invoke(c, key, defvalue);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception " + e));
            e.printStackTrace();
        }
    }
}

