/*
 * Decompiled with CFR 0.152.
 */
package com.device.manager.sdk.tiramusu.biz;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.device.manager.sdk.tiramusu.biz.SystemPropBean;
import com.device.manager.sdk.tiramusu.biz.SystemPropManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;

public class IminDeviceService {
    private static volatile IminDeviceService mInstance = null;
    private static final String TAG = "IminDeviceService";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IminDeviceService getInstance() {
        if (mInstance != null) return mInstance;
        Class<IminDeviceService> clazz = IminDeviceService.class;
        synchronized (IminDeviceService.class) {
            if (mInstance != null) return mInstance;
            mInstance = new IminDeviceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void opencashBox() {
        String tag = SystemPropManager.getSystemProperties("persist.sys.device");
        String open = "1";
        OutputStream out = null;
        if (SystemPropManager.getSystemProperties("ro.system.build.fingerprint").contains("rockchip/rk35")) {
            String defValue = SystemPropManager.getSystemProperties("persist.sys.CASHBOX_ENABLE");
            Log.d((String)"iminLib", (String)("\u83b7\u53d6\u7535\u538b\uff1a" + defValue));
            if (!TextUtils.isEmpty((CharSequence)defValue)) {
                open = defValue;
            }
        }
        String cmd = "echo " + open + " > /sys/class/neostra_gpioctl/dev/gpioctl \n";
        String model = SystemPropBean.getInstance().getModel();
        if (model.equals("D1") || model.equals("D1-Pro") || model.equals("Falcon 1") || model.equals("I22T01") || model.equals("TF1-11") || SystemPropManager.getPlaform().equalsIgnoreCase("ums512")) {
            cmd = "echo " + open + " > /sys/extcon-usb-gpio/cashbox_en \n";
        } else if (tag.contains("D4") && tag.contains("Pro")) {
            cmd = "echo 1 > /sys/devices/platform/112b1000.usb/cashbox_en \n";
        }
        try {
            Process exeEcho = Runtime.getRuntime().exec("sh");
            out = exeEcho.getOutputStream();
            out.write(cmd.getBytes());
            out.flush();
            Log.d((String)"iminLib", (String)(" " + cmd));
        }
        catch (Exception e) {
            Log.d((String)"iminLib", (String)("cmdGpioPwrOn faild :" + e.getMessage()));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    Log.d((String)"iminLib", (String)("close stream faild :" + e.getMessage()));
                }
            }
        }
    }

    public void opencashBox(Context context) {
        if (Build.VERSION.SDK_INT < 33) {
            this.opencashBox();
            return;
        }
        try {
            Object iMinServiceManager = context.getSystemService("iminservice");
            Class<?> c = Class.forName("android.app.iMinServiceManager");
            Method method = c.getMethod("isCashBoxOpen", new Class[0]);
            boolean state = (Boolean)method.invoke(iMinServiceManager, new Object[0]);
            Log.d((String)TAG, (String)("iMinServiceManager is " + iMinServiceManager));
            method = c.getMethod("openCashBox", new Class[0]);
            method.invoke(iMinServiceManager, new Object[0]);
            Log.d((String)TAG, (String)"openCashBox: ok");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCashBoxOpen(Context context) {
        try {
            if (Build.VERSION.SDK_INT < 33) {
                return this.getOldDevCashBoxOpen();
            }
            Object iMinServiceManager = context.getSystemService("iminservice");
            Class<?> c = Class.forName("android.app.iMinServiceManager");
            Method method = c.getMethod("isCashBoxOpen", new Class[0]);
            boolean state = (Boolean)method.invoke(iMinServiceManager, new Object[0]);
            Log.d((String)TAG, (String)("openCashBox: state1=" + state));
            return state;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getOldDevCashBoxOpen() {
        String tag = SystemPropManager.getSystemProperties("persist.sys.device");
        boolean isOpen = false;
        OutputStream out = null;
        String cmd = "cat /sys/class/neostra_gpioctl/dev/gpioctl_sns \n";
        String model = SystemPropBean.getInstance().getModel();
        if (model.equals("D1") || model.equals("D1-Pro") || model.equals("Falcon 1") || model.equals("I22T01") || model.equals("TF1-11") || SystemPropManager.getPlaform().equalsIgnoreCase("ums512")) {
            cmd = "cat /sys/extcon-usb-gpio/cashbox_state \n";
        } else if (tag.contains("D4") && tag.contains("Pro")) {
            cmd = "cat /sys/devices/platform/112b1000.usb/cashbox_state \n";
        }
        try {
            Process exeEcho = Runtime.getRuntime().exec(cmd);
            BufferedReader mReader = new BufferedReader(new InputStreamReader(exeEcho.getInputStream()));
            StringBuffer mRespBuff = new StringBuffer();
            char[] buff = new char[1024];
            int ch = 0;
            while ((ch = mReader.read(buff)) != -1) {
                mRespBuff.append(buff, 0, ch);
            }
            mReader.close();
            Log.i((String)"nioTag2", (String)("\u6267\u884cshell2\u811a\u672c\u6210\u529f " + mRespBuff.toString()));
            isOpen = model.equals("D1") || model.equals("D1-Pro") || model.equals("Falcon 1") || model.equals("I22T01") || model.equals("TF1-11") || SystemPropManager.getPlaform().equalsIgnoreCase("ums512") ? "true".equals(mRespBuff.toString()) || "1".equals(mRespBuff.toString().trim()) : "true".equals(mRespBuff.toString()) || "0".equals(mRespBuff.toString().trim());
            Log.d((String)"iminLib", (String)(" " + cmd + " isOpen" + isOpen));
        }
        catch (Exception e) {
            Log.d((String)"iminLib", (String)("cmdGpioPwrOn faild :" + e.getMessage()));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    Log.d((String)"iminLib", (String)("close stream faild :" + e.getMessage()));
                }
            }
            return isOpen;
        }
    }

    public boolean setCashBoxKeyValue(Context context, String vol) {
        if (Build.VERSION.SDK_INT < 33) {
            return this.setA11CashBoxKeyValue(context, vol);
        }
        try {
            if ("1".equals(vol) || "2".equals(vol) || "3".equals(vol)) {
                Object iMinServiceManager = context.getSystemService("iminservice");
                Class<?> c = Class.forName("android.app.iMinServiceManager");
                Method method = c.getMethod("setCashBoxKeyValue", String.class);
                method.invoke(iMinServiceManager, vol);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean setA11CashBoxKeyValue(Context context, String vol) {
        if ("1".equals(vol) || "2".equals(vol) || "3".equals(vol)) {
            switch (vol) {
                case "1": {
                    vol = "2";
                    break;
                }
                case "2": {
                    vol = "3";
                    break;
                }
                case "3": {
                    vol = "1";
                }
            }
            SystemPropBean.setProperties("persist.sys.CASHBOX_ENABLE", vol);
            this.writeCashBoxSysFile(vol);
            return true;
        }
        return false;
    }

    private void writeCashBoxSysFile(String vol) {
        String path = "/sys/class/neostra_gpioctl/dev/cashbox_ui_val";
        OutputStream out = null;
        try {
            String cmd = "echo " + vol + " > " + path + "\n";
            Process exeEcho = Runtime.getRuntime().exec("sh");
            out = exeEcho.getOutputStream();
            out.write(cmd.getBytes());
            out.flush();
            Log.d((String)"iminLib", (String)(" " + cmd));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.toString());
        }
    }

    public void setAppsHaveUsbPermissions(Context context, String pkgName) {
        try {
            Object iMinServiceManager = context.getSystemService("iminservice");
            Class<?> c = Class.forName("android.app.iMinServiceManager");
            Method method = c.getMethod("setAppsHaveUsbPermissions", String.class);
            method.invoke(iMinServiceManager, pkgName);
            Log.d((String)TAG, (String)("setAppsHaveUsbPermissions: " + pkgName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean setWifiEnable(Context context, boolean isOpen) {
        if (Build.VERSION.SDK_INT >= 33) {
            try {
                Object iMinServiceManager = context.getSystemService("iminservice");
                Class<?> c = Class.forName("android.app.iMinServiceManager");
                Method method = c.getMethod("setWifiEnabled", Boolean.TYPE);
                method.invoke(iMinServiceManager, isOpen);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            Class<?> c = Class.forName("android.app.ActivityManager");
            Method method = c.getMethod("setBtWifi", Integer.TYPE, Integer.TYPE);
            method.invoke((Object)am, 1, isOpen ? 1 : 0);
            Log.d((String)TAG, (String)("setBtWifi : 1, " + (isOpen ? 1 : 0)));
            return true;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                return false;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return false;
            }
        }
    }

    public boolean setBluetoothEnable(Context context, boolean isOpen) {
        if (Build.VERSION.SDK_INT >= 33) {
            try {
                Object iMinServiceManager = context.getSystemService("iminservice");
                Class<?> c = Class.forName("android.app.iMinServiceManager");
                Method method = c.getMethod("setBluetoothEnabled", Boolean.TYPE);
                method.invoke(iMinServiceManager, isOpen);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            try {
                ActivityManager am = (ActivityManager)context.getSystemService("activity");
                Class<?> c = Class.forName("android.app.ActivityManager");
                Method method = c.getMethod("setBtWifi", Integer.TYPE, Integer.TYPE);
                method.invoke((Object)am, 0, isOpen ? 1 : 0);
                Log.d((String)TAG, (String)("setBtWifi : 1, " + (isOpen ? 1 : 0)));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

