/*
 * Decompiled with CFR 0.152.
 */
package com.device.manager.sdk.tiramusu.biz;

import android.app.Instrumentation;

public class ByteUtil {
    private ByteUtil() {
        System.out.println("ByteUtil Constructor");
    }

    public static String byteArraytoString(byte[] b, int len, int offset) {
        byte[] data = new byte[len];
        System.arraycopy(b, offset, data, 0, len);
        return new String(data);
    }

    public static String bytearrayToHexStringNoSpace(byte[] b, int leng) {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < leng; ++i) {
            strbuf.append("0123456789ABCDEF".charAt((byte)((b[i] & 0xF0) >> 4)));
            strbuf.append("0123456789ABCDEF".charAt((byte)(b[i] & 0xF)));
        }
        return strbuf.toString();
    }

    public static String bytesToString(byte[] b) {
        char ch;
        StringBuffer result = new StringBuffer("");
        int length = b.length;
        for (int i = 0; i < length && (ch = (char)(b[i] & 0xFF)) != '\u0000'; ++i) {
            result.append(ch);
        }
        return result.toString();
    }

    public static String bytearrayToHexStringWithSpace(byte[] b, int leng) {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < leng; ++i) {
            strbuf.append("0123456789ABCDEF".charAt((byte)((b[i] & 0xF0) >> 4)));
            strbuf.append("0123456789ABCDEF".charAt((byte)(b[i] & 0xF)));
            strbuf.append(" ");
        }
        return strbuf.toString();
    }

    public static String bytearrayToHexString(byte[] b, int leng) {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < leng; ++i) {
            strbuf.append("0123456789ABCDEF".charAt((byte)((b[i] & 0xF0) >> 4)));
            strbuf.append("0123456789ABCDEF".charAt((byte)(b[i] & 0xF)));
        }
        return strbuf.toString();
    }

    public static byte[] stringToBytes(String s) {
        return s.getBytes();
    }

    public static void ShortToBytes(byte[] b, short x, int offset) {
        if (b.length - offset >= 2) {
            b[offset + 1] = (byte)(x >> 8);
            b[offset + 0] = (byte)(x >> 0);
        }
    }

    public static short BytesToShort(byte[] b, int offset) {
        short x = 0;
        if (b.length - offset >= 2) {
            x = (short)(b[offset + 1] << 8 | b[offset + 0] & 0xFF);
        }
        return x;
    }

    public static String byteToHexString(byte b) {
        StringBuffer sbBuffer = new StringBuffer();
        sbBuffer.append("0123456789ABCDEF".charAt(b >> 4 & 0xF));
        sbBuffer.append("0123456789ABCDEF".charAt(b & 0xF));
        return sbBuffer.toString();
    }

    public static String byteToCharString(byte b) {
        StringBuffer sbBuffer = new StringBuffer();
        sbBuffer.append((char)b);
        return sbBuffer.toString();
    }

    public static void IntToBytes(byte[] b, int x, int offset) {
        if (b.length - offset >= 4) {
            b[offset + 3] = (byte)(x >> 24);
            b[offset + 2] = (byte)(x >> 16);
            b[offset + 1] = (byte)(x >> 8);
            b[offset + 0] = (byte)(x >> 0);
        }
    }

    public static int BytesToInt(byte[] b, int offset) {
        int x = 0;
        if (b.length - offset >= 4) {
            x = (b[offset + 3] & 0xFF) << 24 | (b[offset + 2] & 0xFF) << 16 | (b[offset + 1] & 0xFF) << 8 | (b[offset + 0] & 0xFF) << 0;
        }
        return x;
    }

    public static void LongToBytes(byte[] b, long x, int offset) {
        if (b.length - offset >= 8) {
            b[offset + 7] = (byte)(x >> 56);
            b[offset + 6] = (byte)(x >> 48);
            b[offset + 5] = (byte)(x >> 40);
            b[offset + 4] = (byte)(x >> 32);
            b[offset + 3] = (byte)(x >> 24);
            b[offset + 2] = (byte)(x >> 16);
            b[offset + 1] = (byte)(x >> 8);
            b[offset + 0] = (byte)(x >> 0);
        }
    }

    public static long BytesToLong(byte[] b, int offset) {
        long x = 0L;
        if (b.length - offset >= 8) {
            x = ((long)b[offset + 7] & 0xFFL) << 56 | ((long)b[offset + 6] & 0xFFL) << 48 | ((long)b[offset + 5] & 0xFFL) << 40 | ((long)b[offset + 4] & 0xFFL) << 32 | ((long)b[offset + 3] & 0xFFL) << 24 | ((long)b[offset + 2] & 0xFFL) << 16 | ((long)b[offset + 1] & 0xFFL) << 8 | ((long)b[offset + 0] & 0xFFL) << 0;
        }
        return x;
    }

    public static void CharToBytes(byte[] b, char ch, int offset) {
        if (b.length - offset >= 2) {
            int temp = ch;
            for (int i = 0; i < 2; ++i) {
                b[offset + i] = new Integer(temp & 0xFF).byteValue();
                temp >>= 8;
            }
        }
    }

    public static char BytesToChar(byte[] b, int offset) {
        int s = 0;
        if (b.length - offset >= 2) {
            s = b[offset + 1] > 0 ? (s += b[offset + 1]) : (s += 256 + b[offset + 0]);
            s *= 256;
            s = b[offset + 0] > 0 ? (s += b[offset + 1]) : (s += 256 + b[offset + 0]);
        }
        char ch = (char)s;
        return ch;
    }

    public static void FloatToBytes(byte[] b, float x, int offset) {
        if (b.length - offset >= 4) {
            int l = Float.floatToIntBits(x);
            for (int i = 0; i < 4; ++i) {
                b[offset + i] = new Integer(l).byteValue();
                l >>= 8;
            }
        }
    }

    public static float BytesToFloat(byte[] b, int offset) {
        int l = 0;
        if (b.length - offset >= 4) {
            l = b[offset + 0];
            l &= 0xFF;
            l = (int)((long)l | (long)b[offset + 1] << 8);
            l &= 0xFFFF;
            l = (int)((long)l | (long)b[offset + 2] << 16);
            l &= 0xFFFFFF;
            l = (int)((long)l | (long)b[offset + 3] << 24);
        }
        return Float.intBitsToFloat(l);
    }

    public static void DoubleToBytes(byte[] b, double x, int offset) {
        if (b.length - offset >= 8) {
            long l = Double.doubleToLongBits(x);
            for (int i = 0; i < 4; ++i) {
                b[offset + i] = new Long(l).byteValue();
                l >>= 8;
            }
        }
    }

    public static double BytesToDouble(byte[] b, int offset) {
        long l = 0L;
        if (b.length - offset >= 8) {
            l = b[0];
            l &= 0xFFL;
            l |= (long)b[1] << 8;
            l &= 0xFFFFL;
            l |= (long)b[2] << 16;
            l &= 0xFFFFFFL;
            l |= (long)b[3] << 24;
            l &= 0xFFFFFFFFL;
            l |= (long)b[4] << 32;
            l &= 0xFFFFFFFFFFL;
            l |= (long)b[5] << 40;
            l &= 0xFFFFFFFFFFFFL;
            l |= (long)b[6] << 48;
            l &= 0xFFFFFFFFFFFFFFL;
            l |= (long)b[7] << 56;
        }
        return Double.longBitsToDouble(l);
    }

    public static short toLH(short n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        short ret = ByteUtil.BytesToShort(b, 0);
        return ret;
    }

    public static short toHL(short n) {
        byte[] b = new byte[2];
        b[1] = (byte)(n & 0xFF);
        b[0] = (byte)(n >> 8 & 0xFF);
        short ret = ByteUtil.BytesToShort(b, 0);
        return ret;
    }

    public static int toLH(int n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        int ret = ByteUtil.BytesToInt(b, 0);
        return ret;
    }

    public static int toHL(int n) {
        byte[] b = new byte[4];
        b[3] = (byte)(n & 0xFF);
        b[2] = (byte)(n >> 8 & 0xFF);
        b[1] = (byte)(n >> 16 & 0xFF);
        b[0] = (byte)(n >> 24 & 0xFF);
        int ret = ByteUtil.BytesToInt(b, 0);
        return ret;
    }

    public static long toLH(long n) {
        byte[] b = new byte[]{(byte)(n & 0xFFL), (byte)(n >> 8 & 0xFFL), (byte)(n >> 16 & 0xFFL), (byte)(n >> 24 & 0xFFL), (byte)(n >> 32 & 0xFFL), (byte)(n >> 40 & 0xFFL), (byte)(n >> 48 & 0xFFL), (byte)(n >> 56 & 0xFFL)};
        long ret = ByteUtil.BytesToLong(b, 0);
        return ret;
    }

    public static long toHL(long n) {
        byte[] b = new byte[8];
        b[7] = (byte)(n & 0xFFL);
        b[6] = (byte)(n >> 8 & 0xFFL);
        b[5] = (byte)(n >> 16 & 0xFFL);
        b[4] = (byte)(n >> 24 & 0xFFL);
        b[3] = (byte)(n >> 32 & 0xFFL);
        b[2] = (byte)(n >> 40 & 0xFFL);
        b[1] = (byte)(n >> 48 & 0xFFL);
        b[0] = (byte)(n >> 56 & 0xFFL);
        long ret = ByteUtil.BytesToLong(b, 0);
        return ret;
    }

    public static void encodeOutputBytes(byte[] b, short sLen) {
        if (b.length >= sLen + 2) {
            System.arraycopy(b, 0, b, 2, sLen);
            byte[] byShort = new byte[2];
            ByteUtil.ShortToBytes(byShort, sLen, 0);
            System.arraycopy(byShort, 0, b, 0, byShort.length);
        }
    }

    public static short decodeOutputBytes(byte[] b) {
        byte[] byShort = new byte[2];
        System.arraycopy(b, 0, byShort, 0, byShort.length);
        short sLen = ByteUtil.BytesToShort(byShort, 0);
        System.arraycopy(b, 2, b, 0, sLen);
        return sLen;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(ByteUtil.charToByte(hexChars[pos]) << 4 | ByteUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static int keyReport(int keyValue) {
        int keycode = 0;
        String upKeycode = "";
        int up = 0;
        switch (keyValue) {
            case 32: {
                keycode = 62;
                break;
            }
            case 33: {
                up = 65;
                upKeycode = "!";
                break;
            }
            case 34: {
                up = 65;
                upKeycode = "\"";
                break;
            }
            case 35: {
                keycode = 18;
                break;
            }
            case 36: {
                up = 65;
                upKeycode = "$";
                break;
            }
            case 37: {
                up = 65;
                upKeycode = "%";
                break;
            }
            case 38: {
                up = 65;
                upKeycode = "&";
                break;
            }
            case 39: {
                up = 65;
                upKeycode = "`";
                break;
            }
            case 40: {
                up = 65;
                upKeycode = "(";
                break;
            }
            case 41: {
                up = 65;
                upKeycode = ")";
                break;
            }
            case 42: {
                keycode = 17;
                break;
            }
            case 43: {
                keycode = 81;
                break;
            }
            case 44: {
                keycode = 55;
                break;
            }
            case 45: {
                keycode = 69;
                break;
            }
            case 46: {
                keycode = 56;
                break;
            }
            case 47: {
                keycode = 76;
                break;
            }
            case 48: {
                keycode = 7;
                break;
            }
            case 49: {
                keycode = 8;
                break;
            }
            case 50: {
                keycode = 9;
                break;
            }
            case 51: {
                keycode = 10;
                break;
            }
            case 52: {
                keycode = 11;
                break;
            }
            case 53: {
                keycode = 12;
                break;
            }
            case 54: {
                keycode = 13;
                break;
            }
            case 55: {
                keycode = 14;
                break;
            }
            case 56: {
                keycode = 15;
                break;
            }
            case 57: {
                keycode = 16;
                break;
            }
            case 58: {
                up = 65;
                upKeycode = ":";
                break;
            }
            case 59: {
                keycode = 74;
                break;
            }
            case 60: {
                up = 65;
                upKeycode = "<";
                break;
            }
            case 61: {
                keycode = 70;
                break;
            }
            case 62: {
                up = 65;
                upKeycode = ">";
                break;
            }
            case 63: {
                up = 65;
                upKeycode = "?";
                break;
            }
            case 64: {
                keycode = 77;
                break;
            }
            case 65: {
                up = 65;
                upKeycode = "A";
                break;
            }
            case 97: {
                keycode = 29;
                break;
            }
            case 66: {
                up = 66;
                upKeycode = "B";
                break;
            }
            case 98: {
                keycode = 30;
                break;
            }
            case 67: {
                up = 67;
                upKeycode = "C";
                break;
            }
            case 99: {
                keycode = 31;
                break;
            }
            case 68: {
                up = 68;
                upKeycode = "D";
                break;
            }
            case 100: {
                keycode = 32;
                break;
            }
            case 69: {
                up = 69;
                upKeycode = "E";
                break;
            }
            case 101: {
                keycode = 33;
                break;
            }
            case 70: {
                up = 70;
                upKeycode = "F";
                break;
            }
            case 102: {
                keycode = 34;
                break;
            }
            case 71: {
                up = 71;
                upKeycode = "G";
                break;
            }
            case 103: {
                keycode = 35;
                break;
            }
            case 72: {
                up = 72;
                upKeycode = "H";
                break;
            }
            case 104: {
                keycode = 36;
                break;
            }
            case 73: {
                up = 73;
                upKeycode = "I";
                break;
            }
            case 105: {
                keycode = 37;
                break;
            }
            case 74: {
                up = 74;
                upKeycode = "J";
                break;
            }
            case 106: {
                keycode = 38;
                break;
            }
            case 75: {
                up = 75;
                upKeycode = "K";
                break;
            }
            case 107: {
                keycode = 39;
                break;
            }
            case 76: {
                up = 76;
                upKeycode = "L";
                break;
            }
            case 108: {
                keycode = 40;
                break;
            }
            case 77: {
                up = 77;
                upKeycode = "M";
                break;
            }
            case 109: {
                keycode = 41;
                break;
            }
            case 78: {
                up = 78;
                upKeycode = "N";
                break;
            }
            case 110: {
                keycode = 42;
                break;
            }
            case 79: {
                up = 79;
                upKeycode = "O";
                break;
            }
            case 111: {
                keycode = 43;
                break;
            }
            case 80: {
                up = 80;
                upKeycode = "P";
                break;
            }
            case 112: {
                keycode = 44;
                break;
            }
            case 81: {
                up = 81;
                upKeycode = "Q";
                break;
            }
            case 113: {
                keycode = 45;
                break;
            }
            case 82: {
                up = 82;
                upKeycode = "R";
                break;
            }
            case 114: {
                keycode = 46;
                break;
            }
            case 83: {
                up = 83;
                upKeycode = "S";
                break;
            }
            case 115: {
                keycode = 47;
                break;
            }
            case 84: {
                up = 84;
                upKeycode = "T";
                break;
            }
            case 116: {
                keycode = 48;
                break;
            }
            case 85: {
                up = 85;
                upKeycode = "U";
                break;
            }
            case 117: {
                keycode = 49;
                break;
            }
            case 86: {
                up = 86;
                upKeycode = "V";
                break;
            }
            case 118: {
                keycode = 50;
                break;
            }
            case 87: {
                up = 87;
                upKeycode = "W";
                break;
            }
            case 119: {
                keycode = 51;
                break;
            }
            case 88: {
                up = 88;
                upKeycode = "X";
                break;
            }
            case 120: {
                keycode = 52;
                break;
            }
            case 89: {
                up = 89;
                upKeycode = "Y";
                break;
            }
            case 121: {
                keycode = 53;
                break;
            }
            case 90: {
                up = 90;
                upKeycode = "Z";
                break;
            }
            case 122: {
                keycode = 54;
                break;
            }
            case 91: {
                keycode = 71;
                break;
            }
            case 92: {
                keycode = 73;
                break;
            }
            case 93: {
                keycode = 72;
                break;
            }
            case -77: {
                keycode = 131;
                break;
            }
            case -78: {
                keycode = 19;
                break;
            }
            case -72: {
                keycode = 20;
                break;
            }
            case -76: {
                keycode = 21;
                break;
            }
            case -74: {
                keycode = 22;
                break;
            }
            case -71: {
                keycode = 82;
                break;
            }
            case -73: {
                keycode = 78;
                break;
            }
            case 5: {
                keycode = 4;
                break;
            }
            case 27: {
                keycode = 67;
                break;
            }
            case 13: {
                keycode = 66;
                break;
            }
            case 2: {
                keycode = 140;
                break;
            }
            case 3: {
                keycode = 141;
                break;
            }
            case 4: {
                keycode = 142;
                break;
            }
            default: {
                keycode = 0;
            }
        }
        try {
            Instrumentation inst = new Instrumentation();
            if (65 <= up && up <= 90) {
                inst.sendStringSync(upKeycode);
            } else {
                inst.sendKeyDownUpSync(keycode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static int crc_cal_by_bit(byte[] ptr, int len) {
        int crc = 0;
        int j = 0;
        while (len-- != 0) {
            for (int i = 128; i != 0; i /= 2) {
                if (((crc *= 2) & 0x10000) != 0) {
                    crc ^= 0x11021;
                }
                if ((ptr[j] & i) == 0) continue;
                crc ^= 0x1021;
            }
            ++j;
        }
        return crc;
    }

    public static void memset(byte[] data, int dataLen) {
        for (int i = 0; i < dataLen; ++i) {
            data[i] = 0;
        }
    }

    public static int checkLenth(byte[] str) {
        int len = 0;
        while (str[len] != 13 || str[len + 1] != 10) {
            ++len;
        }
        return len + 2;
    }
}

