/*
 * Decompiled with CFR 0.152.
 */
package com.device.manager.sdk.tiramusu;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.device.manager.sdk.bean.CPUDetail;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CpuUtils {
    public static final String SOC_MANUFACTURER = "ro.soc.manufacturer";
    public static final String TAG = "CpuUtils";
    public static final String SOC_AW = "Allwinner";

    public static Map<String, String> getCpuInfo() {
        HashMap<String, String> cpuInfo = new HashMap<String, String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));
            while ((line = br.readLine()) != null) {
                if (line.contains("Hardware")) {
                    cpuInfo.put("model", line.split(":\\s+", 2)[1]);
                }
                if (!line.startsWith("CPU revision")) continue;
                cpuInfo.put("revision", line.split(":\\s+", 2)[1]);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cpuInfo;
    }

    private static int getCpuCoreCount() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            File[] files = dir.listFiles((file, name) -> name.matches("cpu[0-9]+"));
            if (files != null) {
                return files.length;
            }
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Runtime.getRuntime().availableProcessors();
        }
    }

    private static Double readFrequencyFromFile(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                String content = new String(Files.readAllBytes(Paths.get(path, new String[0]))).trim();
                return Double.parseDouble(content);
            }
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    private static String getMaxCpuFreq() {
        int coreCount = CpuUtils.getCpuCoreCount();
        Double maxFreq = null;
        for (int i = 0; i < coreCount; ++i) {
            String maxFreqPath = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
            Double freq = CpuUtils.readFrequencyFromFile(maxFreqPath);
            if (freq == null || maxFreq != null && !(freq > maxFreq)) continue;
            maxFreq = freq;
        }
        if (maxFreq == null) {
            return "";
        }
        double cpuMaxFreq = maxFreq / 1000.0 / 1000.0;
        DecimalFormat df = new DecimalFormat("#.0");
        String cpuFreq = df.format(cpuMaxFreq) + "GHz";
        Log.d((String)TAG, (String)("getCpuMaxFreq: maxFreq= " + maxFreq + "\ncpuFreq=" + cpuFreq));
        return cpuFreq;
    }

    public static String getminfreq(int cpu) {
        String result = "";
        try {
            FileReader fr = new FileReader("/sys/devices/system/cpu/cpu" + cpu + "/cpufreq/cpuinfo_min_freq");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            result = text.trim();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getmaxfreq(int cpu) {
        String result = "";
        try {
            FileReader fr = new FileReader("/sys/devices/system/cpu/cpu" + cpu + "/cpufreq/cpuinfo_max_freq");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            result = text.trim();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static float getCpuTemperature() {
        try {
            String filePath = "/sys/class/thermal/thermal_zone0/temp";
            BufferedReader br = new BufferedReader(new FileReader(filePath));
            String line = br.readLine();
            if (line != null) {
                float temperatureCelsius = Float.parseFloat(line) / 1000.0f;
                Log.d((String)TAG, (String)("getCpuTemperature temperatureCelsius: " + temperatureCelsius));
                return temperatureCelsius;
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("getCpuTemperature error: " + e.getMessage()));
            e.printStackTrace();
        }
        return 0.0f;
    }

    public static List<CPUDetail.CPUItem> getCpuClusters(Context context) {
        int cpuIndex = 0;
        ArrayList<CPUDetail.CPUItem> cpus = new ArrayList<CPUDetail.CPUItem>();
        while (true) {
            String path = "/sys/devices/system/cpu/cpu" + cpuIndex + "/topology/physical_package_id";
            try (BufferedReader br = new BufferedReader(new FileReader(path));){
                String line = br.readLine();
                CPUDetail.CPUItem cpuItem = new CPUDetail.CPUItem();
                cpuItem.frequency = CpuUtils.getCurrentCpuFreq(cpuIndex);
                cpuItem.minfreq = CpuUtils.getminfreq(cpuIndex);
                cpuItem.maxfreq = CpuUtils.getmaxfreq(cpuIndex);
                cpuItem.frequencyList = CpuUtils.getfrequencyList(cpuIndex);
                cpuItem.modeList = CpuUtils.getmodeList(cpuIndex);
                cpuItem.online = CpuUtils.getonline(cpuIndex);
                cpus.add(cpuItem);
            }
            catch (IOException e) {
                break;
            }
            ++cpuIndex;
        }
        return cpus;
    }

    private static String getonline(int cpu) {
        String result = "";
        try {
            FileReader fr = new FileReader("/sys/devices/system/cpu/cpu" + cpu + "/online");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            result = text.trim();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getmodeList(int cpu) {
        String result = "";
        try {
            FileReader fr = new FileReader("/sys/devices/system/cpu/cpu" + cpu + "/cpufreq/scaling_available_governors");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            result = text.trim();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Log.e((String)"getCurrentCpuFreq", (String)result);
        return result;
    }

    public static String getfrequencyList(int cpu) {
        String result = "";
        try {
            FileReader fr = new FileReader("/sys/devices/system/cpu/cpu" + cpu + "/cpufreq/scaling_available_frequencies");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            result = text.trim();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCPURateDesc_All() {
        String path = "/proc/stat";
        long[] totalJiffies = new long[2];
        long[] totalIdle = new long[2];
        int firstCPUNum = 0;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        Pattern pattern = Pattern.compile(" [0-9]+");
        for (int i = 0; i < 2; ++i) {
            totalJiffies[i] = 0L;
            totalIdle[i] = 0L;
            try {
                String str;
                fileReader = new FileReader(path);
                bufferedReader = new BufferedReader(fileReader, 8192);
                int currentCPUNum = 0;
                while ((str = bufferedReader.readLine()) != null && (i == 0 || currentCPUNum < firstCPUNum)) {
                    if (str.toLowerCase().startsWith("cpu")) {
                        ++currentCPUNum;
                        int index = 0;
                        Matcher matcher = pattern.matcher(str);
                        while (matcher.find()) {
                            try {
                                long tempJiffies = Long.parseLong(matcher.group(0).trim());
                                int n = i;
                                totalJiffies[n] = totalJiffies[n] + tempJiffies;
                                if (index == 3) {
                                    int n2 = i;
                                    totalIdle[n2] = totalIdle[n2] + tempJiffies;
                                }
                                ++index;
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (i != 0) continue;
                    firstCPUNum = currentCPUNum;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        double rate = -1.0;
        if (totalJiffies[0] > 0L && totalJiffies[1] > 0L && totalJiffies[0] != totalJiffies[1]) {
            rate = 1.0 * (double)(totalJiffies[1] - totalIdle[1] - (totalJiffies[0] - totalIdle[0])) / (double)(totalJiffies[1] - totalJiffies[0]);
        }
        Log.d((String)TAG, (String)("getCPURateDesc_All CpuUtils zrx---- cpu_rate:" + rate));
        if (rate <= 0.0) {
            Log.d((String)TAG, (String)("getCPURateDesc_Allcpu_rate is < 0: " + rate));
            return "1%";
        }
        long a = Math.round(rate * 100.0);
        Log.d((String)TAG, (String)("getCPURateDesc_All  rate :" + a));
        if (a <= 0L) {
            a = 1L;
        } else if (a >= 100L) {
            a = 99L;
        }
        return a + "%";
    }

    public static String getCurrentCpuFreq(int cpu) {
        String result = "";
        try {
            FileReader fr = new FileReader("/sys/devices/system/cpu/cpu" + cpu + "/cpufreq/scaling_cur_freq");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            result = text.trim();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getCpuMaxFreq() {
        String maxCpuFreq = CpuUtils.getMaxCpuFreq();
        if (!TextUtils.isEmpty((CharSequence)maxCpuFreq)) {
            return maxCpuFreq;
        }
        String cpuFreq = "";
        try {
            BufferedReader br;
            String text;
            String manufacturer = CpuUtils.getSystemProperties(SOC_MANUFACTURER);
            Log.d((String)TAG, (String)("getCpuMaxFreq: manufacturer= " + manufacturer));
            String cpuMaxFreqPathFile = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";
            if (manufacturer.equalsIgnoreCase(SOC_AW)) {
                cpuMaxFreqPathFile = "/sys/devices/system/cpu/cpu7/cpufreq/cpuinfo_max_freq";
            }
            if ((text = (br = new BufferedReader(new FileReader(cpuMaxFreqPathFile))).readLine()) != null && !"".equals((text = text.trim()).trim())) {
                double cpuMaxFreq = Double.parseDouble(text.trim()) / 1000.0 / 1000.0;
                DecimalFormat df = new DecimalFormat("#.0");
                cpuFreq = df.format(cpuMaxFreq);
            }
            br.close();
            br = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cpuFreq + "GHz";
    }

    private static String getSystemProperties(String property) {
        String value = "xxx";
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method getter = clazz.getDeclaredMethod("get", String.class);
            value = (String)getter.invoke(null, property);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Unable to read system properties");
        }
        return value;
    }

    public static String getmode(int cpu, Context context) {
        String result = "";
        try {
            result = (String)CpuUtils.opIminServiceNoParas(context, "getCpuModel", null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Object opIminServiceNoParas(Context context, String methodStr, Class<?>[] parameterTypes, Object[] params) {
        Object obj = null;
        try {
            Object iMinServiceManager = context.getSystemService("iminservice");
            if (iMinServiceManager != null) {
                Class<?> c = Class.forName("android.app.iMinServiceManager");
                Method method = null;
                method = parameterTypes == null ? c.getMethod(methodStr, new Class[0]) : c.getMethod(methodStr, parameterTypes);
                obj = params == null ? method.invoke(iMinServiceManager, new Object[0]) : method.invoke(iMinServiceManager, params);
                return obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }
}

