/*
 * Decompiled with CFR 0.152.
 */
package com.device.manager.sdk.tiramusu;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import com.device.manager.sdk.tiramusu.A13DeviceManager;
import com.device.manager.server.aidl.IAsyncCallback;
import com.device.manager.server.aidl.IDeviceService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class A13DeviceService
implements IDeviceService {
    A13DeviceManager a13DeviceManager;
    protected final ExecutorService executors = Executors.newSingleThreadExecutor();

    public A13DeviceService(Context context) {
        this.a13DeviceManager = new A13DeviceManager(context);
    }

    @Override
    public String getSystemProperties(String name) throws RemoteException {
        return "";
    }

    @Override
    public void getDeviceInfoAsyn(String name, IAsyncCallback callback) throws RemoteException {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        this.executors.submit(() -> {
            String result = "";
            try {
                result = this.a13DeviceManager.getDeviceInfo(name);
                callback.onResult(result.toString());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void sendAMCommandAsyn(String cmd, IAsyncCallback callback) throws RemoteException {
        if (cmd == null || cmd.isEmpty()) {
            return;
        }
        this.executors.submit(() -> {
            JsonObject result = new JsonObject();
            try {
                JsonObject jsonCMD = new JsonParser().parse(cmd).getAsJsonObject();
                String deviceStatus = this.a13DeviceManager.sendAMCommand((JsonElement)jsonCMD);
                result.addProperty("code", (Number)0);
                result.addProperty("value", deviceStatus);
            }
            catch (Exception e) {
                e.printStackTrace();
                result.addProperty("code", (Number)-1);
            }
            try {
                callback.onResult(result.toString());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void sendDeviceActionAsyn(String type, String cmd, IAsyncCallback callback) throws RemoteException {
        this.executors.submit(() -> {
            String result = "";
            try {
                result = this.a13DeviceManager.sendDeviceActionAsyn(type, cmd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                callback.onResult(result);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public String getBarcodeScannerDetails() throws RemoteException {
        return "";
    }

    @Override
    public String getVideoDisplayDetails() throws RemoteException {
        return "";
    }

    @Override
    public String getEmmcEmbeddedMultimediaCardDetails() throws RemoteException {
        return "";
    }

    @Override
    public String getNFCDetails() throws RemoteException {
        return "";
    }

    @Override
    public String getBuiltinCellularDetails() throws RemoteException {
        return "";
    }

    @Override
    public String getCameraDetails() throws RemoteException {
        return "";
    }

    @Override
    public String getDeviceDetail() throws RemoteException {
        return "";
    }

    @Override
    public String getMemoryDetail() throws RemoteException {
        return "";
    }

    @Override
    public String getBatteryDetail() throws RemoteException {
        return "";
    }

    @Override
    public String getCPUDetail() throws RemoteException {
        return "";
    }

    @Override
    public String getWIFIDetails() throws RemoteException {
        return "";
    }

    @Override
    public String getApplicationDetails() throws RemoteException {
        return "";
    }

    @Override
    public String getPrinterDetails() throws RemoteException {
        return "";
    }

    @Override
    public String getStorageDetails() throws RemoteException {
        return "";
    }

    public IBinder asBinder() {
        return null;
    }
}

