/*
 * Decompiled with CFR 0.152.
 */
package com.device.manager.sdk.tiramusu;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.device.manager.sdk.bean.CPUDetail;
import com.device.manager.sdk.tiramusu.CMD;
import com.device.manager.sdk.tiramusu.CpuUtils;
import com.device.manager.sdk.tiramusu.biz.IminSDKManager;
import com.device.manager.sdk.tiramusu.biz.SystemPropManager;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Method;
import java.util.Map;

public class A13DeviceManager {
    private Context context;
    private String TAG = "A13DeviceManager";

    public A13DeviceManager(Context context) {
        this.context = context;
    }

    public String sendAMCommand(JsonElement cmd) {
        String result;
        block18: {
            result = "";
            try {
                JsonObject jsonCmd;
                if (!cmd.isJsonObject()) break block18;
                JsonObject jsonRoot = cmd.getAsJsonObject();
                if (cmd.isJsonObject() && jsonRoot.has(CMD.CONFIG_OEM_CONFIG)) {
                    Method method;
                    Class<?> c;
                    Object iMinServiceManager;
                    boolean asBoolean;
                    jsonCmd = jsonRoot.getAsJsonObject(CMD.CONFIG_OEM_CONFIG);
                    if (jsonCmd.has(CMD.CONFIG_WIFI_SWITCH)) {
                        asBoolean = jsonCmd.get(CMD.CONFIG_WIFI_SWITCH).getAsBoolean();
                        IminSDKManager.setWifiEnable(this.context, asBoolean);
                    }
                    if (jsonCmd.has(CMD.CONFIG_BLUETOOTH_SWITCH)) {
                        asBoolean = jsonCmd.get(CMD.CONFIG_BLUETOOTH_SWITCH).getAsBoolean();
                        IminSDKManager.setBluetoothEnable(this.context, asBoolean);
                    }
                    if (jsonCmd.has("enableUSBPermission")) {
                        String packageName = jsonCmd.get("enableUSBPermission").getAsString();
                        IminSDKManager.setAppsHaveUsbPermissions(this.context, packageName);
                    }
                    if (jsonCmd.has("setHideStatusBarforiMin")) {
                        boolean status = jsonCmd.get("setHideStatusBarforiMin").getAsBoolean();
                        try {
                            iMinServiceManager = this.context.getSystemService("iminservice");
                            c = Class.forName("android.app.iMinServiceManager");
                            method = c.getMethod("setHideStatusBarforiMin", Boolean.TYPE);
                            method.invoke(iMinServiceManager, status);
                            Log.d((String)this.TAG, (String)" setHideStatusBarforiMin ");
                        }
                        catch (NoSuchMethodException e) {
                            Log.d((String)this.TAG, (String)" setHideStatusBarforiMin sendBroadcast");
                            e.printStackTrace();
                            String HIDE_STATUS_BAR = "android.intent.action.HIDE_STATUS_BAR";
                            Intent intent2 = new Intent(HIDE_STATUS_BAR);
                            intent2.putExtra("isHide_statusbar", status + "");
                            intent2.setPackage("com.android.systemui");
                            this.context.sendBroadcast(intent2);
                        }
                    }
                    if (jsonCmd.has("setHideNavigationBarforiMin")) {
                        boolean status = jsonCmd.get("setHideNavigationBarforiMin").getAsBoolean();
                        try {
                            Log.d((String)this.TAG, (String)" setHideNavigationBarforiMin ");
                            iMinServiceManager = this.context.getSystemService("iminservice");
                            c = Class.forName("android.app.iMinServiceManager");
                            method = c.getMethod("setHideNavigationBarforiMin", Boolean.TYPE);
                            method.invoke(iMinServiceManager, status);
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                            Log.d((String)this.TAG, (String)" setHideNavigationBarforiMin sendBroadcast ");
                            Intent intent = new Intent("android.intent.action.HIDE_NAV_BAR");
                            intent.putExtra("isHide_nav", status + "");
                            intent.setPackage("com.android.systemui");
                            this.context.sendBroadcast(intent);
                        }
                    }
                }
                if (cmd.isJsonObject() && jsonRoot.has("peripheralConfig")) {
                    jsonCmd = jsonRoot.getAsJsonObject("peripheralConfig");
                    if (jsonCmd.has("isCashBoxOpen")) {
                        result = String.valueOf(IminSDKManager.isCashBoxOpen(this.context));
                    } else if (jsonCmd.has("openCashBox")) {
                        IminSDKManager.opencashBox(this.context);
                    } else if (jsonCmd.has("setCashBoxKeyValue")) {
                        result = String.valueOf(IminSDKManager.setCashBoxKeyValue(this.context, jsonCmd.get("setCashBoxKeyValue").getAsString()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String getDeviceInfo(String name) {
        switch (name) {
            case "DEVICE_INFO_GET_MODEL": {
                return SystemPropManager.getModel();
            }
            case "DEVICE_INFO_GET_PLATFORM": {
                return SystemPropManager.getPlaform();
            }
            case "DEVICE_INFO_GET_BRAND": {
                return SystemPropManager.getBrand();
            }
            case "DEVICE_INFO_GET_SN": {
                return SystemPropManager.getSn();
            }
            case "DEVICE_INFO_CPU_INFO": {
                return this.getCPUInfo();
            }
            case "DEVICE_INFO_GET_DUALSCREEN": {
                return SystemPropManager.getDualscreenProp(this.context);
            }
            case "DEVICE_INFO_ISSUPPERCASHBOX": {
                return String.valueOf(SystemPropManager.isSupperCashBox());
            }
            case "DEVICE_INFO_HW_INFO": {
                return this.getHWInfo();
            }
        }
        return "";
    }

    private String getCPUInfo() {
        Gson gson = new Gson();
        CPUDetail eDetail = new CPUDetail();
        try {
            ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            eDetail.manufacturer = Build.MANUFACTURER;
            Map<String, String> cpus = CpuUtils.getCpuInfo();
            eDetail.model = CpuUtils.getmode(0, this.context);
            eDetail.totalCPU = CpuUtils.getCpuMaxFreq();
            eDetail.usedCPU = CpuUtils.getCPURateDesc_All();
            eDetail.revision = cpus.get("revision");
            eDetail.cores = Runtime.getRuntime().availableProcessors() + "";
            eDetail.cpu = CpuUtils.getCpuClusters(this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gson.toJson((Object)eDetail);
    }

    private String getHWInfo() {
        JsonObject result = new JsonObject();
        result.addProperty("model", SystemPropManager.getModel());
        result.addProperty("brand", SystemPropManager.getBrand());
        result.addProperty("serialNumber", SystemPropManager.getSn());
        result.addProperty("hardware", SystemPropManager.getPlaform());
        result.addProperty("dualscreenProp", SystemPropManager.getDualscreenProp(this.context));
        return result.toString();
    }

    public String sendDeviceActionAsyn(String type, String cmd) {
        String result = "";
        if ("isCashBoxOpen".equals(type)) {
            result = String.valueOf(IminSDKManager.isCashBoxOpen(this.context));
        } else if ("cashbox_en".equals(type) && !TextUtils.isEmpty((CharSequence)cmd)) {
            result = String.valueOf(IminSDKManager.setCashBoxKeyValue(this.context, cmd));
        }
        return result;
    }
}

